/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.UCI10n;
import com.mypurecloud.sdk.v2.model.UCIcon;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="UC Integration UI configuration data")
public class UnifiedCommunicationsIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private AddressableEntityRef ucIntegrationKey = null;
    private IntegrationPresenceSourceEnum integrationPresenceSource = null;
    private String pbxPermission = null;
    private UCIcon icon = null;
    private Map<String, UCIcon> badgeIcons = null;
    private Map<String, UCI10n> i10n = null;
    private Boolean polledPresence = null;
    private Integer pollIntervalSec = null;
    private List<String> userPermissions = new ArrayList<String>();
    private List<String> oauthScopes = new ArrayList<String>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public UnifiedCommunicationsIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", required=true, value="ucIntegrationKey")
    @JsonProperty(value="ucIntegrationKey")
    public AddressableEntityRef getUcIntegrationKey() {
        return this.ucIntegrationKey;
    }

    @ApiModelProperty(example="null", required=true, value="integrationPresenceType")
    @JsonProperty(value="integrationPresenceSource")
    public IntegrationPresenceSourceEnum getIntegrationPresenceSource() {
        return this.integrationPresenceSource;
    }

    @ApiModelProperty(example="null", required=true, value="pbxPermission")
    @JsonProperty(value="pbxPermission")
    public String getPbxPermission() {
        return this.pbxPermission;
    }

    @ApiModelProperty(example="null", required=true, value="icon")
    @JsonProperty(value="icon")
    public UCIcon getIcon() {
        return this.icon;
    }

    @ApiModelProperty(example="null", required=true, value="badgeIcon")
    @JsonProperty(value="badgeIcons")
    public Map<String, UCIcon> getBadgeIcons() {
        return this.badgeIcons;
    }

    @ApiModelProperty(example="null", required=true, value="i10n")
    @JsonProperty(value="i10n")
    public Map<String, UCI10n> getI10n() {
        return this.i10n;
    }

    @ApiModelProperty(example="null", required=true, value="polledPresence")
    @JsonProperty(value="polledPresence")
    public Boolean getPolledPresence() {
        return this.polledPresence;
    }

    @ApiModelProperty(example="null", value="pollIntervalSec")
    @JsonProperty(value="pollIntervalSec")
    public Integer getPollIntervalSec() {
        return this.pollIntervalSec;
    }

    @ApiModelProperty(example="null", required=true, value="userPermissions")
    @JsonProperty(value="userPermissions")
    public List<String> getUserPermissions() {
        return this.userPermissions;
    }

    public UnifiedCommunicationsIntegration oauthScopes(List<String> oauthScopes) {
        this.oauthScopes = oauthScopes;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="oauthScopes")
    public List<String> getOauthScopes() {
        return this.oauthScopes;
    }

    public void setOauthScopes(List<String> oauthScopes) {
        this.oauthScopes = oauthScopes;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnifiedCommunicationsIntegration unifiedCommunicationsIntegration = (UnifiedCommunicationsIntegration)o;
        return Objects.equals(this.id, unifiedCommunicationsIntegration.id) && Objects.equals(this.name, unifiedCommunicationsIntegration.name) && Objects.equals(this.ucIntegrationKey, unifiedCommunicationsIntegration.ucIntegrationKey) && Objects.equals((Object)this.integrationPresenceSource, (Object)unifiedCommunicationsIntegration.integrationPresenceSource) && Objects.equals(this.pbxPermission, unifiedCommunicationsIntegration.pbxPermission) && Objects.equals(this.icon, unifiedCommunicationsIntegration.icon) && Objects.equals(this.badgeIcons, unifiedCommunicationsIntegration.badgeIcons) && Objects.equals(this.i10n, unifiedCommunicationsIntegration.i10n) && Objects.equals(this.polledPresence, unifiedCommunicationsIntegration.polledPresence) && Objects.equals(this.pollIntervalSec, unifiedCommunicationsIntegration.pollIntervalSec) && Objects.equals(this.userPermissions, unifiedCommunicationsIntegration.userPermissions) && Objects.equals(this.oauthScopes, unifiedCommunicationsIntegration.oauthScopes) && Objects.equals(this.selfUri, unifiedCommunicationsIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.ucIntegrationKey, this.integrationPresenceSource, this.pbxPermission, this.icon, this.badgeIcons, this.i10n, this.polledPresence, this.pollIntervalSec, this.userPermissions, this.oauthScopes, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnifiedCommunicationsIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ucIntegrationKey: ").append(this.toIndentedString(this.ucIntegrationKey)).append("\n");
        sb.append("    integrationPresenceSource: ").append(this.toIndentedString((Object)this.integrationPresenceSource)).append("\n");
        sb.append("    pbxPermission: ").append(this.toIndentedString(this.pbxPermission)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString(this.icon)).append("\n");
        sb.append("    badgeIcons: ").append(this.toIndentedString(this.badgeIcons)).append("\n");
        sb.append("    i10n: ").append(this.toIndentedString(this.i10n)).append("\n");
        sb.append("    polledPresence: ").append(this.toIndentedString(this.polledPresence)).append("\n");
        sb.append("    pollIntervalSec: ").append(this.toIndentedString(this.pollIntervalSec)).append("\n");
        sb.append("    userPermissions: ").append(this.toIndentedString(this.userPermissions)).append("\n");
        sb.append("    oauthScopes: ").append(this.toIndentedString(this.oauthScopes)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=IntegrationPresenceSourceEnumDeserializer.class)
    public static enum IntegrationPresenceSourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MICROSOFTTEAMS("MicrosoftTeams"),
        ZOOMPHONE("ZoomPhone"),
        EIGHTBYEIGHT("EightByEight");

        private String value;

        private IntegrationPresenceSourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IntegrationPresenceSourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IntegrationPresenceSourceEnum value : IntegrationPresenceSourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IntegrationPresenceSourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class IntegrationPresenceSourceEnumDeserializer
    extends StdDeserializer<IntegrationPresenceSourceEnum> {
        public IntegrationPresenceSourceEnumDeserializer() {
            super(IntegrationPresenceSourceEnumDeserializer.class);
        }

        public IntegrationPresenceSourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return IntegrationPresenceSourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

