/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.CustomEventAttribute;
import com.mypurecloud.sdk.v2.model.RequestPage;
import com.mypurecloud.sdk.v2.model.WebEventBrowser;
import com.mypurecloud.sdk.v2.model.WebEventDevice;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class WebEventRequest
implements Serializable {
    private String customerCookieId = null;
    private String eventName = null;
    private RequestPage page = null;
    private String userAgentString = null;
    private WebEventBrowser browser = null;
    private WebEventDevice device = null;
    private String searchQuery = null;
    private String ipAddress = null;
    private String referrerUrl = null;
    private Map<String, CustomEventAttribute> attributes = null;
    private Map<String, CustomEventAttribute> traits = null;
    private Date createdDate = null;

    public WebEventRequest customerCookieId(String customerCookieId) {
        this.customerCookieId = customerCookieId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A UUID representing the customer making the request.")
    @JsonProperty(value="customerCookieId")
    public String getCustomerCookieId() {
        return this.customerCookieId;
    }

    public void setCustomerCookieId(String customerCookieId) {
        this.customerCookieId = customerCookieId;
    }

    public WebEventRequest eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. page_viewed, order_completed, user_registered.")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public WebEventRequest page(RequestPage page) {
        this.page = page;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The webpage where the user interaction occurred.")
    @JsonProperty(value="page")
    public RequestPage getPage() {
        return this.page;
    }

    public void setPage(RequestPage page) {
        this.page = page;
    }

    public WebEventRequest userAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
        return this;
    }

    @ApiModelProperty(example="null", value="Override for HTTP User-Agent string from request header (see https://tools.ietf.org/html/rfc1945#section-10.15).")
    @JsonProperty(value="userAgentString")
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public WebEventRequest browser(WebEventBrowser browser) {
        this.browser = browser;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's browser.")
    @JsonProperty(value="browser")
    public WebEventBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(WebEventBrowser browser) {
        this.browser = browser;
    }

    public WebEventRequest device(WebEventDevice device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's device.")
    @JsonProperty(value="device")
    public WebEventDevice getDevice() {
        return this.device;
    }

    public void setDevice(WebEventDevice device) {
        this.device = device;
    }

    public WebEventRequest searchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the keywords in a customer search query.")
    @JsonProperty(value="searchQuery")
    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public WebEventRequest ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP address.")
    @JsonProperty(value="ipAddress")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public WebEventRequest referrerUrl(String referrerUrl) {
        this.referrerUrl = referrerUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifies the referrer URL that originally generated the request for the current page being viewed.")
    @JsonProperty(value="referrerUrl")
    public String getReferrerUrl() {
        return this.referrerUrl;
    }

    public void setReferrerUrl(String referrerUrl) {
        this.referrerUrl = referrerUrl;
    }

    public WebEventRequest attributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.")
    @JsonProperty(value="attributes")
    public Map<String, CustomEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
    }

    public WebEventRequest traits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
        return this;
    }

    @ApiModelProperty(example="null", value="Traits are attributes intrinsic to the customer that may be sent in selected events, e.g. email, lastName, cellPhone. Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.")
    @JsonProperty(value="traits")
    public Map<String, CustomEventAttribute> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
    }

    public WebEventRequest createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebEventRequest webEventRequest = (WebEventRequest)o;
        return Objects.equals(this.customerCookieId, webEventRequest.customerCookieId) && Objects.equals(this.eventName, webEventRequest.eventName) && Objects.equals(this.page, webEventRequest.page) && Objects.equals(this.userAgentString, webEventRequest.userAgentString) && Objects.equals(this.browser, webEventRequest.browser) && Objects.equals(this.device, webEventRequest.device) && Objects.equals(this.searchQuery, webEventRequest.searchQuery) && Objects.equals(this.ipAddress, webEventRequest.ipAddress) && Objects.equals(this.referrerUrl, webEventRequest.referrerUrl) && Objects.equals(this.attributes, webEventRequest.attributes) && Objects.equals(this.traits, webEventRequest.traits) && Objects.equals(this.createdDate, webEventRequest.createdDate);
    }

    public int hashCode() {
        return Objects.hash(this.customerCookieId, this.eventName, this.page, this.userAgentString, this.browser, this.device, this.searchQuery, this.ipAddress, this.referrerUrl, this.attributes, this.traits, this.createdDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebEventRequest {\n");
        sb.append("    customerCookieId: ").append(this.toIndentedString(this.customerCookieId)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    userAgentString: ").append(this.toIndentedString(this.userAgentString)).append("\n");
        sb.append("    browser: ").append(this.toIndentedString(this.browser)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    searchQuery: ").append(this.toIndentedString(this.searchQuery)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    referrerUrl: ").append(this.toIndentedString(this.referrerUrl)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    traits: ").append(this.toIndentedString(this.traits)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

