/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.QueryCriteria;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The response for QueryCapabilities which contains the allowed criteria, flow types and action types for the organization.")
public class FlowsQueryCriteriaResponse
implements Serializable {
    private List<QueryCriteria> criteria = new ArrayList<QueryCriteria>();
    private List<FlowTypesEnum> flowTypes = new ArrayList<FlowTypesEnum>();
    private List<ActionTypesEnum> actionTypes = new ArrayList<ActionTypesEnum>();
    private List<String> errorCodes = new ArrayList<String>();
    private List<String> warningCodes = new ArrayList<String>();

    public FlowsQueryCriteriaResponse criteria(List<QueryCriteria> criteria) {
        this.criteria = criteria;
        return this;
    }

    @ApiModelProperty(example="null", value="The is a list of allowed criteria to query on.")
    @JsonProperty(value="criteria")
    public List<QueryCriteria> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List<QueryCriteria> criteria) {
        this.criteria = criteria;
    }

    public FlowsQueryCriteriaResponse flowTypes(List<FlowTypesEnum> flowTypes) {
        this.flowTypes = flowTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="The is a list of flow types the organization has access to.")
    @JsonProperty(value="flowTypes")
    public List<FlowTypesEnum> getFlowTypes() {
        return this.flowTypes;
    }

    public void setFlowTypes(List<FlowTypesEnum> flowTypes) {
        this.flowTypes = flowTypes;
    }

    public FlowsQueryCriteriaResponse actionTypes(List<ActionTypesEnum> actionTypes) {
        this.actionTypes = actionTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="The is a list of action types the organization has access to.")
    @JsonProperty(value="actionTypes")
    public List<ActionTypesEnum> getActionTypes() {
        return this.actionTypes;
    }

    public void setActionTypes(List<ActionTypesEnum> actionTypes) {
        this.actionTypes = actionTypes;
    }

    public FlowsQueryCriteriaResponse errorCodes(List<String> errorCodes) {
        this.errorCodes = errorCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="The is a list of potential error codes the organization may encounter.")
    @JsonProperty(value="errorCodes")
    public List<String> getErrorCodes() {
        return this.errorCodes;
    }

    public void setErrorCodes(List<String> errorCodes) {
        this.errorCodes = errorCodes;
    }

    public FlowsQueryCriteriaResponse warningCodes(List<String> warningCodes) {
        this.warningCodes = warningCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="The is a list of potential warning codes the organization may encounter.")
    @JsonProperty(value="warningCodes")
    public List<String> getWarningCodes() {
        return this.warningCodes;
    }

    public void setWarningCodes(List<String> warningCodes) {
        this.warningCodes = warningCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowsQueryCriteriaResponse flowsQueryCriteriaResponse = (FlowsQueryCriteriaResponse)o;
        return Objects.equals(this.criteria, flowsQueryCriteriaResponse.criteria) && Objects.equals(this.flowTypes, flowsQueryCriteriaResponse.flowTypes) && Objects.equals(this.actionTypes, flowsQueryCriteriaResponse.actionTypes) && Objects.equals(this.errorCodes, flowsQueryCriteriaResponse.errorCodes) && Objects.equals(this.warningCodes, flowsQueryCriteriaResponse.warningCodes);
    }

    public int hashCode() {
        return Objects.hash(this.criteria, this.flowTypes, this.actionTypes, this.errorCodes, this.warningCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowsQueryCriteriaResponse {\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("    flowTypes: ").append(this.toIndentedString(this.flowTypes)).append("\n");
        sb.append("    actionTypes: ").append(this.toIndentedString(this.actionTypes)).append("\n");
        sb.append("    errorCodes: ").append(this.toIndentedString(this.errorCodes)).append("\n");
        sb.append("    warningCodes: ").append(this.toIndentedString(this.warningCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionTypesEnumDeserializer.class)
    public static enum ActionTypesEnum {
        ACTIONABORTSURVEYINVITE("actionAbortSurveyInvite"),
        ACTIONADDFLOWMILESTONE("actionAddFlowMilestone"),
        ACTIONASKFORBOOLEAN("actionAskForBoolean"),
        ACTIONASKFORNLUINTENT("actionAskForNLUIntent"),
        ACTIONASKFORNLUNEXTINTENT("actionAskForNLUNextIntent"),
        ACTIONASKFORSLOT("actionAskForSlot"),
        ACTIONCALLBOTCONNECTOR("actionCallBotConnector"),
        ACTIONCALLBOTFLOW("actionCallBotFlow"),
        ACTIONCALLCOMMONMODULE("actionCallCommonModule"),
        ACTIONCALLDATA("actionCallData"),
        ACTIONCALLDATASECURE("actionCallDataSecure"),
        ACTIONCALLDIALOGENGINEBOT("actionCallDialogEngineBot"),
        ACTIONCALLDIALOGFLOWBOT("actionCallDialogflowBot"),
        ACTIONCALLDIALOGFLOWCXBOT("actionCallDialogflowCxBot"),
        ACTIONCALLDIGITALBOTFLOW("actionCallDigitalBotFlow"),
        ACTIONCALLLEXBOT("actionCallLexBot"),
        ACTIONCALLLEXV2BOT("actionCallLexV2Bot"),
        ACTIONCALLNUANCEMIXBOT("actionCallNuanceMixBot"),
        ACTIONCALLTASK("actionCallTask"),
        ACTIONCHANGESTATE("actionChangeState"),
        ACTIONCLEARSLOT("actionClearSlot"),
        ACTIONCLEARVOICEMAILSNIPPET("actionClearVoicemailSnippet"),
        ACTIONCOLLECTINPUT("actionCollectInput"),
        ACTIONCOMMUNICATE("actionCommunicate"),
        ACTIONCOMPLETESURVEYINVITE("actionCompleteSurveyInvite"),
        ACTIONCREATECALLBACK("actionCreateCallback"),
        ACTIONDATATABLELOOKUP("actionDataTableLookup"),
        ACTIONDECISION("actionDecision"),
        ACTIONDECRYPTDATA("actionDecryptData"),
        ACTIONDETECTSILENCE("actionDetectSilence"),
        ACTIONDIALEXTENSION("actionDialExtension"),
        ACTIONDIALNAME("actionDialName"),
        ACTIONDIGITALMENU("actionDigitalMenu"),
        ACTIONDISCONNECT("actionDisconnect"),
        ACTIONENABLEPARTICIPANTRECORD("actionEnableParticipantRecord"),
        ACTIONENCRYPTDATA("actionEncryptData"),
        ACTIONENDSTATE("actionEndState"),
        ACTIONENDTASK("actionEndTask"),
        ACTIONENDWORKFLOW("actionEndWorkflow"),
        ACTIONEVALUATESCHEDULE("actionEvaluateSchedule"),
        ACTIONEVALUATESCHEDULEGROUP("actionEvaluateScheduleGroup"),
        ACTIONEXITBOTFLOW("actionExitBotFlow"),
        ACTIONEXITLOOP("actionExitLoop"),
        ACTIONEXTRACTSECUREDATA("actionExtractSecureData"),
        ACTIONFINDEMERGENCYGROUP("actionFindEmergencyGroup"),
        ACTIONFINDGROUP("actionFindGroup"),
        ACTIONFINDLANGUAGESKILL("actionFindLanguageSkill"),
        ACTIONFINDQUEUE("actionFindQueue"),
        ACTIONFINDQUEUEBYID("actionFindQueueById"),
        ACTIONFINDSCHEDULE("actionFindSchedule"),
        ACTIONFINDSCHEDULEGROUP("actionFindScheduleGroup"),
        ACTIONFINDSKILL("actionFindSkill"),
        ACTIONFINDSYSTEMPROMPT("actionFindSystemPrompt"),
        ACTIONFINDUSER("actionFindUser"),
        ACTIONFINDUSERBYID("actionFindUserById"),
        ACTIONFINDUSERPROMPT("actionFindUserPrompt"),
        ACTIONFINDUSERSBYID("actionFindUsersById"),
        ACTIONFLUSHAUDIO("actionFlushAudio"),
        ACTIONGETCONVERSATIONDATA("actionGetConversationData"),
        ACTIONGETEXTERNALCONTACT("actionGetExternalContact"),
        ACTIONGETEXTERNALORGANIZATION("actionGetExternalOrganization"),
        ACTIONGETJOURNEYOUTCOME("actionGetJourneyOutcome"),
        ACTIONGETJOURNEYOUTCOMESCORESBYSESSION("actionGetJourneyOutcomeScoresBySession"),
        ACTIONGETJOURNEYSEGMENT("actionGetJourneySegment"),
        ACTIONGETJOURNEYSESSION("actionGetJourneySession"),
        ACTIONGETJOURNEYSESSIONSBYCUSTOMER("actionGetJourneySessionsByCustomer"),
        ACTIONGETJOURNEYSESSIONSBYEXTERNALCONTACT("actionGetJourneySessionsByExternalContact"),
        ACTIONGETPARTICIPANTDATA("actionGetParticipantData"),
        ACTIONGETRESPONSE("actionGetResponse"),
        ACTIONGETSECUREDDATA("actionGetSecuredData"),
        ACTIONHOLDMUSIC("actionHoldMusic"),
        ACTIONINITIALIZEFLOWOUTCOME("actionInitializeFlowOutcome"),
        ACTIONJUMPTOMENU("actionJumpToMenu"),
        ACTIONJUMPTOTASK("actionJumpToTask"),
        ACTIONLOOP("actionLoop"),
        ACTIONLOOPUNTIL("actionLoopUntil"),
        ACTIONNEXTLOOP("actionNextLoop"),
        ACTIONPLAYAUDIO("actionPlayAudio"),
        ACTIONPLAYAUDIOONSILENCE("actionPlayAudioOnSilence"),
        ACTIONPLAYESTIMATEDWAITTIME("actionPlayEstimatedWaitTime"),
        ACTIONPLAYPOSITIONINQUEUE("actionPlayPositionInQueue"),
        ACTIONPLAYUSERGREETING("actionPlayUserGreeting"),
        ACTIONPLAYUSERNAME("actionPlayUserName"),
        ACTIONPREVIOUSMENU("actionPreviousMenu"),
        ACTIONPROCESSVOICEMAILINPUT("actionProcessVoicemailInput"),
        ACTIONREPEATMENU("actionRepeatMenu"),
        ACTIONRETURNTOAGENT("actionReturnToAgent"),
        ACTIONSAVEWORKITEM("actionSaveWorkitem"),
        ACTIONSCREENPOP("actionScreenPop"),
        ACTIONSEARCHEXTERNALCONTACTS("actionSearchExternalContacts"),
        ACTIONSENDAUTOREPLY("actionSendAutoReply"),
        ACTIONSENDRESPONSE("actionSendResponse"),
        ACTIONSETACTIVEINTENT("actionSetActiveIntent"),
        ACTIONSETCONVERSATIONDATA("actionSetConversationData"),
        ACTIONSETEXTERNALTAG("actionSetExternalTag"),
        ACTIONSETFLOWOUTCOME("actionSetFlowOutcome"),
        ACTIONSETLOCALE("actionSetLocale"),
        ACTIONSETPARTICIPANTDATA("actionSetParticipantData"),
        ACTIONSETPRIORITY("actionSetPriority"),
        ACTIONSETSECUREDDATA("actionSetSecuredData"),
        ACTIONSETSKILLS("actionSetSkills"),
        ACTIONSETUUIDATA("actionSetUUIData"),
        ACTIONSETWHISPERAUDIO("actionSetWhisperAudio"),
        ACTIONSETWRAPUPCODE("actionSetWrapupCode"),
        ACTIONSHOWKNOWLEDGEARTICLE("actionShowKnowledgeArticle"),
        ACTIONSUBMITVOICEMAILSNIPPET("actionSubmitVoicemailSnippet"),
        ACTIONSWITCH("actionSwitch"),
        ACTIONTRANSCRIPTION("actionTranscription"),
        ACTIONTRANSFEREXTERNAL("actionTransferExternal"),
        ACTIONTRANSFERFLOW("actionTransferFlow"),
        ACTIONTRANSFERFLOWSECURE("actionTransferFlowSecure"),
        ACTIONTRANSFERGROUP("actionTransferGroup"),
        ACTIONTRANSFERTOACD("actionTransferToAcd"),
        ACTIONTRANSFERUSER("actionTransferUser"),
        ACTIONTRANSFERVOICEMAIL("actionTransferVoicemail"),
        ACTIONUPDATEDATA("actionUpdateData"),
        ACTIONWAIT("actionWait"),
        ACTIONWAITFORINPUT("actionWaitForInput"),
        MENUDIALEXTENSION("menuDialExtension"),
        MENUDIALNAME("menuDialName"),
        MENUDISCONNECT("menuDisconnect"),
        MENUJUMPTOMENU("menuJumpToMenu"),
        MENUJUMPTOTASK("menuJumpToTask"),
        MENUMENU("menuMenu"),
        MENUPREVIOUSMENU("menuPreviousMenu"),
        MENUREPEATMENU("menuRepeatMenu"),
        MENUSHOWKNOWLEDGEARTICLE("menuShowKnowledgeArticle"),
        MENUTASK("menuTask"),
        MENUTRANSFERTOACD("menuTransferToAcd"),
        MENUTRANSFERFLOW("menuTransferFlow"),
        MENUTRANSFERGROUP("menuTransferGroup"),
        MENUTRANSFEREXTERNAL("menuTransferExternal"),
        MENUTRANSFERFLOWSECURE("menuTransferFlowSecure"),
        MENUTRANSFERUSER("menuTransferUser"),
        MENUTRANSFERVOICEMAIL("menuTransferVoicemail");

        private String value;

        private ActionTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionTypesEnum value : ActionTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionTypesEnumDeserializer
    extends StdDeserializer<ActionTypesEnum> {
        public ActionTypesEnumDeserializer() {
            super(ActionTypesEnumDeserializer.class);
        }

        public ActionTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=FlowTypesEnumDeserializer.class)
    public static enum FlowTypesEnum {
        BOT("bot"),
        COMMONMODULE("commonmodule"),
        DIGITALBOT("digitalbot"),
        INBOUNDCALL("inboundcall"),
        INBOUNDCHAT("inboundchat"),
        INBOUNDEMAIL("inboundemail"),
        INBOUNDSHORTMESSAGE("inboundshortmessage"),
        INQUEUECALL("inqueuecall"),
        INQUEUESHORTMESSAGE("inqueueshortmessage"),
        INQUEUEEMAIL("inqueueemail"),
        OUTBOUNDCALL("outboundcall"),
        SECURECALL("securecall"),
        SURVEYINVITE("surveyinvite"),
        VOICE("voice"),
        VOICEMAIL("voicemail"),
        VOICESURVEY("voicesurvey"),
        WORKFLOW("workflow"),
        WORKITEM("workitem");

        private String value;

        private FlowTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlowTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlowTypesEnum value : FlowTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlowTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlowTypesEnumDeserializer
    extends StdDeserializer<FlowTypesEnum> {
        public FlowTypesEnumDeserializer() {
            super(FlowTypesEnumDeserializer.class);
        }

        public FlowTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlowTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

