/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A Video event.")
public class ConversationEventVideo
implements Serializable {
    private TypeEnum type = null;
    private String offeringId = null;
    private String jwt = null;

    public ConversationEventVideo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Describes the type of Video event.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConversationEventVideo offeringId(String offeringId) {
        this.offeringId = offeringId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Video offering ID.")
    @JsonProperty(value="offeringId")
    public String getOfferingId() {
        return this.offeringId;
    }

    public void setOfferingId(String offeringId) {
        this.offeringId = offeringId;
    }

    public ConversationEventVideo jwt(String jwt) {
        this.jwt = jwt;
        return this;
    }

    @ApiModelProperty(example="null", value="The Video offering JWT token.")
    @JsonProperty(value="jwt")
    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationEventVideo conversationEventVideo = (ConversationEventVideo)o;
        return Objects.equals((Object)this.type, (Object)conversationEventVideo.type) && Objects.equals(this.offeringId, conversationEventVideo.offeringId) && Objects.equals(this.jwt, conversationEventVideo.jwt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.offeringId, this.jwt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationEventVideo {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    offeringId: ").append(this.toIndentedString(this.offeringId)).append("\n");
        sb.append("    jwt: ").append(this.toIndentedString(this.jwt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OFFERING("Offering"),
        OFFERINGEXPIRED("OfferingExpired"),
        OFFERINGACCEPTED("OfferingAccepted"),
        OFFERINGREJECTED("OfferingRejected");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

