/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Display attributes for the chart, such as type, labels and legends")
public class JourneyViewChartDisplayAttributes
implements Serializable {
    private TypeEnum type = null;
    private String groupByTitle = null;
    private String metricsTitle = null;
    private Boolean showLegend = null;

    public JourneyViewChartDisplayAttributes type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of chart to display")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public JourneyViewChartDisplayAttributes groupByTitle(String groupByTitle) {
        this.groupByTitle = groupByTitle;
        return this;
    }

    @ApiModelProperty(example="null", value="A title for the grouped by attributes (aka the x axis)")
    @JsonProperty(value="groupByTitle")
    public String getGroupByTitle() {
        return this.groupByTitle;
    }

    public void setGroupByTitle(String groupByTitle) {
        this.groupByTitle = groupByTitle;
    }

    public JourneyViewChartDisplayAttributes metricsTitle(String metricsTitle) {
        this.metricsTitle = metricsTitle;
        return this;
    }

    @ApiModelProperty(example="null", value="A title for the metrics (aka the y axis)")
    @JsonProperty(value="metricsTitle")
    public String getMetricsTitle() {
        return this.metricsTitle;
    }

    public void setMetricsTitle(String metricsTitle) {
        this.metricsTitle = metricsTitle;
    }

    public JourneyViewChartDisplayAttributes showLegend(Boolean showLegend) {
        this.showLegend = showLegend;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to show a legend")
    @JsonProperty(value="showLegend")
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewChartDisplayAttributes journeyViewChartDisplayAttributes = (JourneyViewChartDisplayAttributes)o;
        return Objects.equals((Object)this.type, (Object)journeyViewChartDisplayAttributes.type) && Objects.equals(this.groupByTitle, journeyViewChartDisplayAttributes.groupByTitle) && Objects.equals(this.metricsTitle, journeyViewChartDisplayAttributes.metricsTitle) && Objects.equals(this.showLegend, journeyViewChartDisplayAttributes.showLegend);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.groupByTitle, this.metricsTitle, this.showLegend});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewChartDisplayAttributes {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    groupByTitle: ").append(this.toIndentedString(this.groupByTitle)).append("\n");
        sb.append("    metricsTitle: ").append(this.toIndentedString(this.metricsTitle)).append("\n");
        sb.append("    showLegend: ").append(this.toIndentedString(this.showLegend)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COLUMN("Column"),
        BAR("Bar"),
        LINE("Line");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

