/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class SecureSession
implements Serializable {
    private String id = null;
    private DomainEntityRef flow = null;
    private String userData = null;
    private StateEnum state = null;
    private String sourceParticipantId = null;
    private Boolean disconnect = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SecureSession flow(DomainEntityRef flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The flow to execute securely")
    @JsonProperty(value="flow")
    public DomainEntityRef getFlow() {
        return this.flow;
    }

    public void setFlow(DomainEntityRef flow) {
        this.flow = flow;
    }

    public SecureSession userData(String userData) {
        this.userData = userData;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer-provided data")
    @JsonProperty(value="userData")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public SecureSession state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The current state of a secure session")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SecureSession sourceParticipantId(String sourceParticipantId) {
        this.sourceParticipantId = sourceParticipantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the participant initiating the secure session.")
    @JsonProperty(value="sourceParticipantId")
    public String getSourceParticipantId() {
        return this.sourceParticipantId;
    }

    public void setSourceParticipantId(String sourceParticipantId) {
        this.sourceParticipantId = sourceParticipantId;
    }

    public SecureSession disconnect(Boolean disconnect) {
        this.disconnect = disconnect;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, disconnect the agent after creating the session")
    @JsonProperty(value="disconnect")
    public Boolean getDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(Boolean disconnect) {
        this.disconnect = disconnect;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecureSession secureSession = (SecureSession)o;
        return Objects.equals(this.id, secureSession.id) && Objects.equals(this.flow, secureSession.flow) && Objects.equals(this.userData, secureSession.userData) && Objects.equals((Object)this.state, (Object)secureSession.state) && Objects.equals(this.sourceParticipantId, secureSession.sourceParticipantId) && Objects.equals(this.disconnect, secureSession.disconnect) && Objects.equals(this.selfUri, secureSession.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.flow, this.userData, this.state, this.sourceParticipantId, this.disconnect, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecureSession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    userData: ").append(this.toIndentedString(this.userData)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    sourceParticipantId: ").append(this.toIndentedString(this.sourceParticipantId)).append("\n");
        sb.append("    disconnect: ").append(this.toIndentedString(this.disconnect)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("PENDING"),
        COMPLETED("COMPLETED"),
        FAILED("FAILED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

