/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.OpenMessageEvent;
import com.mypurecloud.sdk.v2.model.OpenMessagingChannel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Open Messaging rich media message structure")
public class OpenEventNormalizedMessage
implements Serializable {
    private String id = null;
    private OpenMessagingChannel channel = null;
    private TypeEnum type = null;
    private List<OpenMessageEvent> events = new ArrayList<OpenMessageEvent>();

    public OpenEventNormalizedMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique ID of the message generated by Messaging Platform.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OpenEventNormalizedMessage channel(OpenMessagingChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public OpenMessagingChannel getChannel() {
        return this.channel;
    }

    public void setChannel(OpenMessagingChannel channel) {
        this.channel = channel;
    }

    public OpenEventNormalizedMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OpenEventNormalizedMessage events(List<OpenMessageEvent> events) {
        this.events = events;
        return this;
    }

    @ApiModelProperty(example="null", value="List of event elements.")
    @JsonProperty(value="events")
    public List<OpenMessageEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<OpenMessageEvent> events) {
        this.events = events;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenEventNormalizedMessage openEventNormalizedMessage = (OpenEventNormalizedMessage)o;
        return Objects.equals(this.id, openEventNormalizedMessage.id) && Objects.equals(this.channel, openEventNormalizedMessage.channel) && Objects.equals((Object)this.type, (Object)openEventNormalizedMessage.type) && Objects.equals(this.events, openEventNormalizedMessage.events);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.type, this.events});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenEventNormalizedMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EVENT("Event");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

