/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Attachment;
import com.mypurecloud.sdk.v2.model.EmailAddress;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class EmailMessagePreview
implements Serializable {
    private String id = null;
    private String name = null;
    private List<EmailAddress> to = new ArrayList<EmailAddress>();
    private List<EmailAddress> cc = new ArrayList<EmailAddress>();
    private List<EmailAddress> bcc = new ArrayList<EmailAddress>();
    private EmailAddress from = null;
    private EmailAddress replyTo = null;
    private String subject = null;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private String textBodyPreview = null;
    private Date time = null;
    private Boolean historyIncluded = null;
    private StateEnum state = null;
    private DraftTypeEnum draftType = null;
    private Integer emailSizeBytes = null;
    private Integer maxEmailSizeBytes = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public EmailMessagePreview name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EmailMessagePreview to(List<EmailAddress> to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipients of the email message.")
    @JsonProperty(value="to")
    public List<EmailAddress> getTo() {
        return this.to;
    }

    public void setTo(List<EmailAddress> to) {
        this.to = to;
    }

    public EmailMessagePreview cc(List<EmailAddress> cc) {
        this.cc = cc;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipients that were copied on the email message.")
    @JsonProperty(value="cc")
    public List<EmailAddress> getCc() {
        return this.cc;
    }

    public void setCc(List<EmailAddress> cc) {
        this.cc = cc;
    }

    public EmailMessagePreview bcc(List<EmailAddress> bcc) {
        this.bcc = bcc;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipients that were blind copied on the email message.")
    @JsonProperty(value="bcc")
    public List<EmailAddress> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<EmailAddress> bcc) {
        this.bcc = bcc;
    }

    public EmailMessagePreview from(EmailAddress from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sender of the email message.")
    @JsonProperty(value="from")
    public EmailAddress getFrom() {
        return this.from;
    }

    public void setFrom(EmailAddress from) {
        this.from = from;
    }

    public EmailMessagePreview replyTo(EmailAddress replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @ApiModelProperty(example="null", value="The receiver of the reply email message.")
    @JsonProperty(value="replyTo")
    public EmailAddress getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EmailAddress replyTo) {
        this.replyTo = replyTo;
    }

    public EmailMessagePreview subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject of the email message.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailMessagePreview attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    @ApiModelProperty(example="null", value="The attachments of the email message.")
    @JsonProperty(value="attachments")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public EmailMessagePreview textBodyPreview(String textBodyPreview) {
        this.textBodyPreview = textBodyPreview;
        return this;
    }

    @ApiModelProperty(example="null", value="A truncated version of the textBody")
    @JsonProperty(value="textBodyPreview")
    public String getTextBodyPreview() {
        return this.textBodyPreview;
    }

    public void setTextBodyPreview(String textBodyPreview) {
        this.textBodyPreview = textBodyPreview;
    }

    public EmailMessagePreview time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public EmailMessagePreview historyIncluded(Boolean historyIncluded) {
        this.historyIncluded = historyIncluded;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the history of previous emails of the conversation is included within the email bodies of this message.")
    @JsonProperty(value="historyIncluded")
    public Boolean getHistoryIncluded() {
        return this.historyIncluded;
    }

    public void setHistoryIncluded(Boolean historyIncluded) {
        this.historyIncluded = historyIncluded;
    }

    public EmailMessagePreview state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the current draft.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public EmailMessagePreview draftType(DraftTypeEnum draftType) {
        this.draftType = draftType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of draft that need to be treated.")
    @JsonProperty(value="draftType")
    public DraftTypeEnum getDraftType() {
        return this.draftType;
    }

    public void setDraftType(DraftTypeEnum draftType) {
        this.draftType = draftType;
    }

    @ApiModelProperty(example="null", value="Indicates an estimation of the size of the current email as a whole, in its final, ready to be sent form.")
    @JsonProperty(value="emailSizeBytes")
    public Integer getEmailSizeBytes() {
        return this.emailSizeBytes;
    }

    @ApiModelProperty(example="null", value="Indicates the maximum allowed size for an email to be send via SMTP server, based on the email domain configuration")
    @JsonProperty(value="maxEmailSizeBytes")
    public Integer getMaxEmailSizeBytes() {
        return this.maxEmailSizeBytes;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailMessagePreview emailMessagePreview = (EmailMessagePreview)o;
        return Objects.equals(this.id, emailMessagePreview.id) && Objects.equals(this.name, emailMessagePreview.name) && Objects.equals(this.to, emailMessagePreview.to) && Objects.equals(this.cc, emailMessagePreview.cc) && Objects.equals(this.bcc, emailMessagePreview.bcc) && Objects.equals(this.from, emailMessagePreview.from) && Objects.equals(this.replyTo, emailMessagePreview.replyTo) && Objects.equals(this.subject, emailMessagePreview.subject) && Objects.equals(this.attachments, emailMessagePreview.attachments) && Objects.equals(this.textBodyPreview, emailMessagePreview.textBodyPreview) && Objects.equals(this.time, emailMessagePreview.time) && Objects.equals(this.historyIncluded, emailMessagePreview.historyIncluded) && Objects.equals((Object)this.state, (Object)emailMessagePreview.state) && Objects.equals((Object)this.draftType, (Object)emailMessagePreview.draftType) && Objects.equals(this.emailSizeBytes, emailMessagePreview.emailSizeBytes) && Objects.equals(this.maxEmailSizeBytes, emailMessagePreview.maxEmailSizeBytes) && Objects.equals(this.selfUri, emailMessagePreview.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.to, this.cc, this.bcc, this.from, this.replyTo, this.subject, this.attachments, this.textBodyPreview, this.time, this.historyIncluded, this.state, this.draftType, this.emailSizeBytes, this.maxEmailSizeBytes, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailMessagePreview {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    textBodyPreview: ").append(this.toIndentedString(this.textBodyPreview)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    historyIncluded: ").append(this.toIndentedString(this.historyIncluded)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    draftType: ").append(this.toIndentedString((Object)this.draftType)).append("\n");
        sb.append("    emailSizeBytes: ").append(this.toIndentedString(this.emailSizeBytes)).append("\n");
        sb.append("    maxEmailSizeBytes: ").append(this.toIndentedString(this.maxEmailSizeBytes)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATED("Created"),
        READY("Ready"),
        EDITED("Edited");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DraftTypeEnumDeserializer.class)
    public static enum DraftTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REPLY("Reply"),
        REPLYALL("ReplyAll"),
        FORWARD("Forward");

        private String value;

        private DraftTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DraftTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DraftTypeEnum value : DraftTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DraftTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DraftTypeEnumDeserializer
    extends StdDeserializer<DraftTypeEnum> {
        public DraftTypeEnumDeserializer() {
            super(DraftTypeEnumDeserializer.class);
        }

        public DraftTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DraftTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

