/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.EvaluationCreateBody;
import java.util.HashMap;
import java.util.Map;

public class PostQualityConversationEvaluationsRequest {
    private String conversationId;
    private EvaluationCreateBody body;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostQualityConversationEvaluationsRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public EvaluationCreateBody getBody() {
        return this.body;
    }

    public void setBody(EvaluationCreateBody body) {
        this.body = body;
    }

    public PostQualityConversationEvaluationsRequest withBody(EvaluationCreateBody body) {
        this.setBody(body);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public PostQualityConversationEvaluationsRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostQualityConversationEvaluationsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<EvaluationCreateBody> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostQualityConversationEvaluationsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostQualityConversationEvaluationsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/quality/conversations/{conversationId}/evaluations").withPathParameter("conversationId", this.conversationId).withQueryParameters("expand", "", this.expand).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, EvaluationCreateBody body) {
        return new Builder().withRequiredParams(conversationId, body);
    }

    public static class Builder {
        private final PostQualityConversationEvaluationsRequest request = new PostQualityConversationEvaluationsRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withBody(EvaluationCreateBody body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withRequiredParams(String conversationId, EvaluationCreateBody body) {
            this.request.setConversationId(conversationId);
            this.request.setBody(body);
            return this;
        }

        public PostQualityConversationEvaluationsRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostQualityConversationEvaluationsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostQualityConversationEvaluationsRequest.");
            }
            return this.request;
        }
    }
}

