/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.FlowLogLevelRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostFlowInstancesSettingsLoglevelsRequest {
    private String flowId;
    private FlowLogLevelRequest body;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public PostFlowInstancesSettingsLoglevelsRequest withFlowId(String flowId) {
        this.setFlowId(flowId);
        return this;
    }

    public FlowLogLevelRequest getBody() {
        return this.body;
    }

    public void setBody(FlowLogLevelRequest body) {
        this.body = body;
    }

    public PostFlowInstancesSettingsLoglevelsRequest withBody(FlowLogLevelRequest body) {
        this.setBody(body);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public PostFlowInstancesSettingsLoglevelsRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostFlowInstancesSettingsLoglevelsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<FlowLogLevelRequest> withHttpInfo() {
        if (this.flowId == null) {
            throw new IllegalStateException("Missing the required parameter 'flowId' when building request for PostFlowInstancesSettingsLoglevelsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostFlowInstancesSettingsLoglevelsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/flows/{flowId}/instances/settings/loglevels").withPathParameter("flowId", this.flowId).withQueryParameters("expand", "multi", this.expand).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String flowId, FlowLogLevelRequest body) {
        return new Builder().withRequiredParams(flowId, body);
    }

    public static class Builder {
        private final PostFlowInstancesSettingsLoglevelsRequest request = new PostFlowInstancesSettingsLoglevelsRequest();

        private Builder() {
        }

        public Builder withFlowId(String flowId) {
            this.request.setFlowId(flowId);
            return this;
        }

        public Builder withBody(FlowLogLevelRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String flowId, FlowLogLevelRequest body) {
            this.request.setFlowId(flowId);
            this.request.setBody(body);
            return this;
        }

        public PostFlowInstancesSettingsLoglevelsRequest build() {
            if (this.request.flowId == null) {
                throw new IllegalStateException("Missing the required parameter 'flowId' when building request for PostFlowInstancesSettingsLoglevelsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostFlowInstancesSettingsLoglevelsRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        NAME("name"),
        TYPE("type"),
        LOGLEVELCHARACTERISTICS_CHARACTERISTICS("logLevelCharacteristics.characteristics");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

