/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.GrammarFileUploadRequest;
import java.util.HashMap;
import java.util.Map;

public class PostArchitectGrammarLanguageFilesVoiceRequest {
    private String grammarId;
    private String languageCode;
    private GrammarFileUploadRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGrammarId() {
        return this.grammarId;
    }

    public void setGrammarId(String grammarId) {
        this.grammarId = grammarId;
    }

    public PostArchitectGrammarLanguageFilesVoiceRequest withGrammarId(String grammarId) {
        this.setGrammarId(grammarId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public PostArchitectGrammarLanguageFilesVoiceRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public GrammarFileUploadRequest getBody() {
        return this.body;
    }

    public void setBody(GrammarFileUploadRequest body) {
        this.body = body;
    }

    public PostArchitectGrammarLanguageFilesVoiceRequest withBody(GrammarFileUploadRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostArchitectGrammarLanguageFilesVoiceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<GrammarFileUploadRequest> withHttpInfo() {
        if (this.grammarId == null) {
            throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PostArchitectGrammarLanguageFilesVoiceRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostArchitectGrammarLanguageFilesVoiceRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostArchitectGrammarLanguageFilesVoiceRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/architect/grammars/{grammarId}/languages/{languageCode}/files/voice").withPathParameter("grammarId", this.grammarId).withPathParameter("languageCode", this.languageCode).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String grammarId, String languageCode, GrammarFileUploadRequest body) {
        return new Builder().withRequiredParams(grammarId, languageCode, body);
    }

    public static class Builder {
        private final PostArchitectGrammarLanguageFilesVoiceRequest request = new PostArchitectGrammarLanguageFilesVoiceRequest();

        private Builder() {
        }

        public Builder withGrammarId(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withBody(GrammarFileUploadRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String grammarId, String languageCode, GrammarFileUploadRequest body) {
            this.request.setGrammarId(grammarId);
            this.request.setLanguageCode(languageCode);
            this.request.setBody(body);
            return this;
        }

        public PostArchitectGrammarLanguageFilesVoiceRequest build() {
            if (this.request.grammarId == null) {
                throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PostArchitectGrammarLanguageFilesVoiceRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostArchitectGrammarLanguageFilesVoiceRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostArchitectGrammarLanguageFilesVoiceRequest.");
            }
            return this.request;
        }
    }
}

