/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Context;
import com.mypurecloud.sdk.v2.model.ExternalSegment;
import com.mypurecloud.sdk.v2.model.Journey;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class JourneySegment
implements Serializable {
    private String id = null;
    private Boolean isActive = null;
    private String displayName = null;
    private Integer version = null;
    private String description = null;
    private String color = null;
    private ScopeEnum scope = null;
    private Boolean shouldDisplayToAgent = null;
    private Context context = null;
    private Journey journey = null;
    private ExternalSegment externalSegment = null;
    private Integer assignmentExpirationDays = null;
    private String selfUri = null;
    private Date createdDate = null;
    private Date modifiedDate = null;

    public JourneySegment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the segment.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JourneySegment isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether or not the segment is active.")
    @JsonProperty(value="isActive")
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public JourneySegment displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The display name of the segment.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JourneySegment version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the segment.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public JourneySegment description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the segment.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JourneySegment color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The hexadecimal color value of the segment.")
    @JsonProperty(value="color")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public JourneySegment scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The target entity that a segment applies to.")
    @JsonProperty(value="scope")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public JourneySegment shouldDisplayToAgent(Boolean shouldDisplayToAgent) {
        this.shouldDisplayToAgent = shouldDisplayToAgent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether or not the segment should be displayed to agent/supervisor users.")
    @JsonProperty(value="shouldDisplayToAgent")
    public Boolean getShouldDisplayToAgent() {
        return this.shouldDisplayToAgent;
    }

    public void setShouldDisplayToAgent(Boolean shouldDisplayToAgent) {
        this.shouldDisplayToAgent = shouldDisplayToAgent;
    }

    public JourneySegment context(Context context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The context of the segment.")
    @JsonProperty(value="context")
    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public JourneySegment journey(Journey journey) {
        this.journey = journey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The pattern of rules defining the segment.")
    @JsonProperty(value="journey")
    public Journey getJourney() {
        return this.journey;
    }

    public void setJourney(Journey journey) {
        this.journey = journey;
    }

    public JourneySegment externalSegment(ExternalSegment externalSegment) {
        this.externalSegment = externalSegment;
        return this;
    }

    @ApiModelProperty(example="null", value="Details of an entity corresponding to this segment in an external system.")
    @JsonProperty(value="externalSegment")
    public ExternalSegment getExternalSegment() {
        return this.externalSegment;
    }

    public void setExternalSegment(ExternalSegment externalSegment) {
        this.externalSegment = externalSegment;
    }

    public JourneySegment assignmentExpirationDays(Integer assignmentExpirationDays) {
        this.assignmentExpirationDays = assignmentExpirationDays;
        return this;
    }

    @ApiModelProperty(example="null", value="Time, in days, from when the segment is assigned until it is automatically unassigned.")
    @JsonProperty(value="assignmentExpirationDays")
    public Integer getAssignmentExpirationDays() {
        return this.assignmentExpirationDays;
    }

    public void setAssignmentExpirationDays(Integer assignmentExpirationDays) {
        this.assignmentExpirationDays = assignmentExpirationDays;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public JourneySegment createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp indicating when the segment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public JourneySegment modifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp indicating when the the segment was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneySegment journeySegment = (JourneySegment)o;
        return Objects.equals(this.id, journeySegment.id) && Objects.equals(this.isActive, journeySegment.isActive) && Objects.equals(this.displayName, journeySegment.displayName) && Objects.equals(this.version, journeySegment.version) && Objects.equals(this.description, journeySegment.description) && Objects.equals(this.color, journeySegment.color) && Objects.equals((Object)this.scope, (Object)journeySegment.scope) && Objects.equals(this.shouldDisplayToAgent, journeySegment.shouldDisplayToAgent) && Objects.equals(this.context, journeySegment.context) && Objects.equals(this.journey, journeySegment.journey) && Objects.equals(this.externalSegment, journeySegment.externalSegment) && Objects.equals(this.assignmentExpirationDays, journeySegment.assignmentExpirationDays) && Objects.equals(this.selfUri, journeySegment.selfUri) && Objects.equals(this.createdDate, journeySegment.createdDate) && Objects.equals(this.modifiedDate, journeySegment.modifiedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.isActive, this.displayName, this.version, this.description, this.color, this.scope, this.shouldDisplayToAgent, this.context, this.journey, this.externalSegment, this.assignmentExpirationDays, this.selfUri, this.createdDate, this.modifiedDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneySegment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("    shouldDisplayToAgent: ").append(this.toIndentedString(this.shouldDisplayToAgent)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    journey: ").append(this.toIndentedString(this.journey)).append("\n");
        sb.append("    externalSegment: ").append(this.toIndentedString(this.externalSegment)).append("\n");
        sb.append("    assignmentExpirationDays: ").append(this.toIndentedString(this.assignmentExpirationDays)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ScopeEnumDeserializer.class)
    public static enum ScopeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SESSION("Session"),
        CUSTOMER("Customer");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScopeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ScopeEnum value : ScopeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ScopeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ScopeEnumDeserializer
    extends StdDeserializer<ScopeEnum> {
        public ScopeEnumDeserializer() {
            super(ScopeEnumDeserializer.class);
        }

        public ScopeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ScopeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

