/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ChatMediaParticipant;
import com.mypurecloud.sdk.v2.model.TransferResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ChatConversation
implements Serializable {
    private String id = null;
    private String name = null;
    private List<ChatMediaParticipant> participants = new ArrayList<ChatMediaParticipant>();
    private List<String> otherMediaUris = new ArrayList<String>();
    private List<TransferResponse> recentTransfers = new ArrayList<TransferResponse>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ChatConversation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChatConversation participants(List<ChatMediaParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of participants involved in the conversation.")
    @JsonProperty(value="participants")
    public List<ChatMediaParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<ChatMediaParticipant> participants) {
        this.participants = participants;
    }

    public ChatConversation otherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of other media channels involved in the conversation.")
    @JsonProperty(value="otherMediaUris")
    public List<String> getOtherMediaUris() {
        return this.otherMediaUris;
    }

    public void setOtherMediaUris(List<String> otherMediaUris) {
        this.otherMediaUris = otherMediaUris;
    }

    public ChatConversation recentTransfers(List<TransferResponse> recentTransfers) {
        this.recentTransfers = recentTransfers;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the most recent 20 transfer commands applied to this conversation.")
    @JsonProperty(value="recentTransfers")
    public List<TransferResponse> getRecentTransfers() {
        return this.recentTransfers;
    }

    public void setRecentTransfers(List<TransferResponse> recentTransfers) {
        this.recentTransfers = recentTransfers;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatConversation chatConversation = (ChatConversation)o;
        return Objects.equals(this.id, chatConversation.id) && Objects.equals(this.name, chatConversation.name) && Objects.equals(this.participants, chatConversation.participants) && Objects.equals(this.otherMediaUris, chatConversation.otherMediaUris) && Objects.equals(this.recentTransfers, chatConversation.recentTransfers) && Objects.equals(this.selfUri, chatConversation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.participants, this.otherMediaUris, this.recentTransfers, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChatConversation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    otherMediaUris: ").append(this.toIndentedString(this.otherMediaUris)).append("\n");
        sb.append("    recentTransfers: ").append(this.toIndentedString(this.recentTransfers)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

