/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BuTimeOffLimitRange
implements Serializable {
    private LocalDate startDate = null;
    private List<Integer> limitMinutesPerDay = new ArrayList<Integer>();

    public BuTimeOffLimitRange startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Start date of the range. The end date is determined by the size of 'limitMinutesPerDay'. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public BuTimeOffLimitRange limitMinutesPerDay(List<Integer> limitMinutesPerDay) {
        this.limitMinutesPerDay = limitMinutesPerDay;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of time-off limit values in minutes per day. If 'null' is specified, then the day-specific value is cleared. Such a day will have a value of 0")
    @JsonProperty(value="limitMinutesPerDay")
    public List<Integer> getLimitMinutesPerDay() {
        return this.limitMinutesPerDay;
    }

    public void setLimitMinutesPerDay(List<Integer> limitMinutesPerDay) {
        this.limitMinutesPerDay = limitMinutesPerDay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuTimeOffLimitRange buTimeOffLimitRange = (BuTimeOffLimitRange)o;
        return Objects.equals(this.startDate, buTimeOffLimitRange.startDate) && Objects.equals(this.limitMinutesPerDay, buTimeOffLimitRange.limitMinutesPerDay);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.limitMinutesPerDay);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuTimeOffLimitRange {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    limitMinutesPerDay: ").append(this.toIndentedString(this.limitMinutesPerDay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

