/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.PatchPredictorRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchRoutingPredictorRequest {
    private String predictorId;
    private PatchPredictorRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getPredictorId() {
        return this.predictorId;
    }

    public void setPredictorId(String predictorId) {
        this.predictorId = predictorId;
    }

    public PatchRoutingPredictorRequest withPredictorId(String predictorId) {
        this.setPredictorId(predictorId);
        return this;
    }

    public PatchPredictorRequest getBody() {
        return this.body;
    }

    public void setBody(PatchPredictorRequest body) {
        this.body = body;
    }

    public PatchRoutingPredictorRequest withBody(PatchPredictorRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchRoutingPredictorRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<PatchPredictorRequest> withHttpInfo() {
        if (this.predictorId == null) {
            throw new IllegalStateException("Missing the required parameter 'predictorId' when building request for PatchRoutingPredictorRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/routing/predictors/{predictorId}").withPathParameter("predictorId", this.predictorId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String predictorId) {
        return new Builder().withRequiredParams(predictorId);
    }

    public static class Builder {
        private final PatchRoutingPredictorRequest request = new PatchRoutingPredictorRequest();

        private Builder() {
        }

        public Builder withPredictorId(String predictorId) {
            this.request.setPredictorId(predictorId);
            return this;
        }

        public Builder withBody(PatchPredictorRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String predictorId) {
            this.request.setPredictorId(predictorId);
            return this;
        }

        public PatchRoutingPredictorRequest build() {
            if (this.request.predictorId == null) {
                throw new IllegalStateException("Missing the required parameter 'predictorId' when building request for PatchRoutingPredictorRequest.");
            }
            return this.request;
        }
    }
}

