/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUserRolesRequest {
    private String subjectId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public GetUserRolesRequest withSubjectId(String subjectId) {
        this.setSubjectId(subjectId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUserRolesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.subjectId == null) {
            throw new IllegalStateException("Missing the required parameter 'subjectId' when building request for GetUserRolesRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/{subjectId}/roles").withPathParameter("subjectId", this.subjectId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String subjectId) {
        return new Builder().withRequiredParams(subjectId);
    }

    public static class Builder {
        private final GetUserRolesRequest request = new GetUserRolesRequest();

        private Builder() {
        }

        public Builder withSubjectId(String subjectId) {
            this.request.setSubjectId(subjectId);
            return this;
        }

        public Builder withRequiredParams(String subjectId) {
            this.request.setSubjectId(subjectId);
            return this;
        }

        public GetUserRolesRequest build() {
            if (this.request.subjectId == null) {
                throw new IllegalStateException("Missing the required parameter 'subjectId' when building request for GetUserRolesRequest.");
            }
            return this.request;
        }
    }
}

