/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class AttendanceStatus
implements Serializable {
    private LocalDate dateWorkday = null;
    private AttendanceStatusTypeEnum attendanceStatusType = null;
    private HasEvaluationEnum hasEvaluation = null;

    @ApiModelProperty(example="null", value="the workday date of this attendance status. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateWorkday")
    public LocalDate getDateWorkday() {
        return this.dateWorkday;
    }

    @ApiModelProperty(example="null", value="the attendance status")
    @JsonProperty(value="attendanceStatusType")
    public AttendanceStatusTypeEnum getAttendanceStatusType() {
        return this.attendanceStatusType;
    }

    @ApiModelProperty(example="null", value="the quality evaluation score status")
    @JsonProperty(value="hasEvaluation")
    public HasEvaluationEnum getHasEvaluation() {
        return this.hasEvaluation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttendanceStatus attendanceStatus = (AttendanceStatus)o;
        return Objects.equals(this.dateWorkday, attendanceStatus.dateWorkday) && Objects.equals((Object)this.attendanceStatusType, (Object)attendanceStatus.attendanceStatusType) && Objects.equals((Object)this.hasEvaluation, (Object)attendanceStatus.hasEvaluation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateWorkday, this.attendanceStatusType, this.hasEvaluation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttendanceStatus {\n");
        sb.append("    dateWorkday: ").append(this.toIndentedString(this.dateWorkday)).append("\n");
        sb.append("    attendanceStatusType: ").append(this.toIndentedString((Object)this.attendanceStatusType)).append("\n");
        sb.append("    hasEvaluation: ").append(this.toIndentedString((Object)this.hasEvaluation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AttendanceStatusTypeEnumDeserializer.class)
    public static enum AttendanceStatusTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HASDATA("HasData"),
        SCHEDULED("Scheduled"),
        ABSENT("Absent"),
        PRESENT("Present"),
        NOSCHEDULE("NoSchedule");

        private String value;

        private AttendanceStatusTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttendanceStatusTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AttendanceStatusTypeEnum value : AttendanceStatusTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AttendanceStatusTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=HasEvaluationEnumDeserializer.class)
    public static enum HasEvaluationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HASQUALITYEVALUATION("HasQualityEvaluation"),
        NOQUALITYEVALUATION("NoQualityEvaluation");

        private String value;

        private HasEvaluationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static HasEvaluationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (HasEvaluationEnum value : HasEvaluationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return HasEvaluationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class HasEvaluationEnumDeserializer
    extends StdDeserializer<HasEvaluationEnum> {
        public HasEvaluationEnumDeserializer() {
            super(HasEvaluationEnumDeserializer.class);
        }

        public HasEvaluationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return HasEvaluationEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AttendanceStatusTypeEnumDeserializer
    extends StdDeserializer<AttendanceStatusTypeEnum> {
        public AttendanceStatusTypeEnumDeserializer() {
            super(AttendanceStatusTypeEnumDeserializer.class);
        }

        public AttendanceStatusTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AttendanceStatusTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

