/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class PhoneTransferEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private TransferTypeEnum transferType = null;
    private String commandId = null;
    private String initiatingCommunicationId = null;
    private String targetCommunicationId = null;
    private String objectCommunicationId = null;
    private String destinationPhoneNumber = null;

    public PhoneTransferEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public PhoneTransferEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public PhoneTransferEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PhoneTransferEvent transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates the desired type of transfer.")
    @JsonProperty(value="transferType")
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public PhoneTransferEvent commandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) used by the external platform to refer to the transfer in subsequent Transfer events.")
    @JsonProperty(value="commandId")
    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public PhoneTransferEvent initiatingCommunicationId(String initiatingCommunicationId) {
        this.initiatingCommunicationId = initiatingCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication representing the participant that is initiating the transfer.")
    @JsonProperty(value="initiatingCommunicationId")
    public String getInitiatingCommunicationId() {
        return this.initiatingCommunicationId;
    }

    public void setInitiatingCommunicationId(String initiatingCommunicationId) {
        this.initiatingCommunicationId = initiatingCommunicationId;
    }

    public PhoneTransferEvent targetCommunicationId(String targetCommunicationId) {
        this.targetCommunicationId = targetCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication that is being transferred away from. In many cases this will be the same as the `initiatingCommunicationId`.")
    @JsonProperty(value="targetCommunicationId")
    public String getTargetCommunicationId() {
        return this.targetCommunicationId;
    }

    public void setTargetCommunicationId(String targetCommunicationId) {
        this.targetCommunicationId = targetCommunicationId;
    }

    public PhoneTransferEvent objectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication that is being transferred.")
    @JsonProperty(value="objectCommunicationId")
    public String getObjectCommunicationId() {
        return this.objectCommunicationId;
    }

    public void setObjectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
    }

    public PhoneTransferEvent destinationPhoneNumber(String destinationPhoneNumber) {
        this.destinationPhoneNumber = destinationPhoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The desired destination phone number that the object communication should be transferred to.")
    @JsonProperty(value="destinationPhoneNumber")
    public String getDestinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public void setDestinationPhoneNumber(String destinationPhoneNumber) {
        this.destinationPhoneNumber = destinationPhoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneTransferEvent phoneTransferEvent = (PhoneTransferEvent)o;
        return Objects.equals(this.eventId, phoneTransferEvent.eventId) && Objects.equals(this.eventDateTime, phoneTransferEvent.eventDateTime) && Objects.equals(this.conversationId, phoneTransferEvent.conversationId) && Objects.equals((Object)this.transferType, (Object)phoneTransferEvent.transferType) && Objects.equals(this.commandId, phoneTransferEvent.commandId) && Objects.equals(this.initiatingCommunicationId, phoneTransferEvent.initiatingCommunicationId) && Objects.equals(this.targetCommunicationId, phoneTransferEvent.targetCommunicationId) && Objects.equals(this.objectCommunicationId, phoneTransferEvent.objectCommunicationId) && Objects.equals(this.destinationPhoneNumber, phoneTransferEvent.destinationPhoneNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventId, this.eventDateTime, this.conversationId, this.transferType, this.commandId, this.initiatingCommunicationId, this.targetCommunicationId, this.objectCommunicationId, this.destinationPhoneNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneTransferEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    commandId: ").append(this.toIndentedString(this.commandId)).append("\n");
        sb.append("    initiatingCommunicationId: ").append(this.toIndentedString(this.initiatingCommunicationId)).append("\n");
        sb.append("    targetCommunicationId: ").append(this.toIndentedString(this.targetCommunicationId)).append("\n");
        sb.append("    objectCommunicationId: ").append(this.toIndentedString(this.objectCommunicationId)).append("\n");
        sb.append("    destinationPhoneNumber: ").append(this.toIndentedString(this.destinationPhoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TransferTypeEnumDeserializer.class)
    public static enum TransferTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTENDED("Attended"),
        UNATTENDED("Unattended");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TransferTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TransferTypeEnum value : TransferTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TransferTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TransferTypeEnumDeserializer
    extends StdDeserializer<TransferTypeEnum> {
        public TransferTypeEnumDeserializer() {
            super(TransferTypeEnumDeserializer.class);
        }

        public TransferTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TransferTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

