/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentFeedback;
import java.util.HashMap;
import java.util.Map;

public class PostKnowledgeKnowledgebaseDocumentFeedbackRequest {
    private String knowledgeBaseId;
    private String documentId;
    private KnowledgeDocumentFeedback body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PostKnowledgeKnowledgebaseDocumentFeedbackRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PostKnowledgeKnowledgebaseDocumentFeedbackRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public KnowledgeDocumentFeedback getBody() {
        return this.body;
    }

    public void setBody(KnowledgeDocumentFeedback body) {
        this.body = body;
    }

    public PostKnowledgeKnowledgebaseDocumentFeedbackRequest withBody(KnowledgeDocumentFeedback body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostKnowledgeKnowledgebaseDocumentFeedbackRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KnowledgeDocumentFeedback> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseDocumentFeedbackRequest.");
        }
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PostKnowledgeKnowledgebaseDocumentFeedbackRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/documents/{documentId}/feedback").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("documentId", this.documentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String documentId) {
        return new Builder().withRequiredParams(knowledgeBaseId, documentId);
    }

    public static class Builder {
        private final PostKnowledgeKnowledgebaseDocumentFeedbackRequest request = new PostKnowledgeKnowledgebaseDocumentFeedbackRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withBody(KnowledgeDocumentFeedback body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String documentId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setDocumentId(documentId);
            return this;
        }

        public PostKnowledgeKnowledgebaseDocumentFeedbackRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseDocumentFeedbackRequest.");
            }
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PostKnowledgeKnowledgebaseDocumentFeedbackRequest.");
            }
            return this.request;
        }
    }
}

