/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class UserPresenceEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String userId = null;
    private String sourceId = null;
    private String presenceDefinitionId = null;
    private String message = null;

    public UserPresenceEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public UserPresenceEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public UserPresenceEvent userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The User ID of the user associated with this UserPresence")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UserPresenceEvent sourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the presence source being updated")
    @JsonProperty(value="sourceId")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public UserPresenceEvent presenceDefinitionId(String presenceDefinitionId) {
        this.presenceDefinitionId = presenceDefinitionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id (UUID) of the presence definition that the user presence is associated with")
    @JsonProperty(value="presenceDefinitionId")
    public String getPresenceDefinitionId() {
        return this.presenceDefinitionId;
    }

    public void setPresenceDefinitionId(String presenceDefinitionId) {
        this.presenceDefinitionId = presenceDefinitionId;
    }

    public UserPresenceEvent message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", value="The message associated with the presence")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPresenceEvent userPresenceEvent = (UserPresenceEvent)o;
        return Objects.equals(this.eventId, userPresenceEvent.eventId) && Objects.equals(this.eventDateTime, userPresenceEvent.eventDateTime) && Objects.equals(this.userId, userPresenceEvent.userId) && Objects.equals(this.sourceId, userPresenceEvent.sourceId) && Objects.equals(this.presenceDefinitionId, userPresenceEvent.presenceDefinitionId) && Objects.equals(this.message, userPresenceEvent.message);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDateTime, this.userId, this.sourceId, this.presenceDefinitionId, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPresenceEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sourceId: ").append(this.toIndentedString(this.sourceId)).append("\n");
        sb.append("    presenceDefinitionId: ").append(this.toIndentedString(this.presenceDefinitionId)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

