/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.MessageTypingEventRequest;
import java.util.HashMap;
import java.util.Map;

public class PostConversationsMessageCommunicationTypingRequest {
    private String conversationId;
    private String communicationId;
    private MessageTypingEventRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationsMessageCommunicationTypingRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public PostConversationsMessageCommunicationTypingRequest withCommunicationId(String communicationId) {
        this.setCommunicationId(communicationId);
        return this;
    }

    public MessageTypingEventRequest getBody() {
        return this.body;
    }

    public void setBody(MessageTypingEventRequest body) {
        this.body = body;
    }

    public PostConversationsMessageCommunicationTypingRequest withBody(MessageTypingEventRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsMessageCommunicationTypingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<MessageTypingEventRequest> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsMessageCommunicationTypingRequest.");
        }
        if (this.communicationId == null) {
            throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PostConversationsMessageCommunicationTypingRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsMessageCommunicationTypingRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/messages/{conversationId}/communications/{communicationId}/typing").withPathParameter("conversationId", this.conversationId).withPathParameter("communicationId", this.communicationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String communicationId, MessageTypingEventRequest body) {
        return new Builder().withRequiredParams(conversationId, communicationId, body);
    }

    public static class Builder {
        private final PostConversationsMessageCommunicationTypingRequest request = new PostConversationsMessageCommunicationTypingRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withCommunicationId(String communicationId) {
            this.request.setCommunicationId(communicationId);
            return this;
        }

        public Builder withBody(MessageTypingEventRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String communicationId, MessageTypingEventRequest body) {
            this.request.setConversationId(conversationId);
            this.request.setCommunicationId(communicationId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsMessageCommunicationTypingRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsMessageCommunicationTypingRequest.");
            }
            if (this.request.communicationId == null) {
                throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PostConversationsMessageCommunicationTypingRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsMessageCommunicationTypingRequest.");
            }
            return this.request;
        }
    }
}

