/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ReportSchedule;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutAnalyticsReportingScheduleRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String scheduleId;
    private ReportSchedule body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public PutAnalyticsReportingScheduleRequest withScheduleId(String scheduleId) {
        this.setScheduleId(scheduleId);
        return this;
    }

    public ReportSchedule getBody() {
        return this.body;
    }

    public void setBody(ReportSchedule body) {
        this.body = body;
    }

    public PutAnalyticsReportingScheduleRequest withBody(ReportSchedule body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutAnalyticsReportingScheduleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ReportSchedule> withHttpInfo() {
        if (this.scheduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'scheduleId' when building request for PutAnalyticsReportingScheduleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAnalyticsReportingScheduleRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/analytics/reporting/schedules/{scheduleId}").withPathParameter("scheduleId", this.scheduleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scheduleId, ReportSchedule body) {
        return new Builder().withRequiredParams(scheduleId, body);
    }

    public static class Builder {
        private final PutAnalyticsReportingScheduleRequest request = new PutAnalyticsReportingScheduleRequest();

        private Builder() {
        }

        public Builder withScheduleId(String scheduleId) {
            this.request.setScheduleId(scheduleId);
            return this;
        }

        public Builder withBody(ReportSchedule body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String scheduleId, ReportSchedule body) {
            this.request.setScheduleId(scheduleId);
            this.request.setBody(body);
            return this;
        }

        public PutAnalyticsReportingScheduleRequest build() {
            return this.request;
        }
    }
}

