/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.LearningAssignmentStepScoStructure;
import com.mypurecloud.sdk.v2.model.LearningAssignmentStepSignedCookie;
import com.mypurecloud.sdk.v2.model.LearningModuleInformStep;
import com.mypurecloud.sdk.v2.model.LearningShareableContentObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning assignment step")
public class LearningAssignmentStep
implements Serializable {
    private String id = null;
    private LearningModuleInformStep moduleStep = null;
    private List<LearningAssignmentStepScoStructure> structure = new ArrayList<LearningAssignmentStepScoStructure>();
    private SuccessStatusEnum successStatus = null;
    private CompletionStatusEnum completionStatus = null;
    private Float completionPercentage = null;
    private Float percentageScore = null;
    private LearningShareableContentObject shareableContentObject = null;
    private LearningAssignmentStepSignedCookie signedCookie = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The ID of the learning assignment step")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The module step data for this step")
    @JsonProperty(value="moduleStep")
    public LearningModuleInformStep getModuleStep() {
        return this.moduleStep;
    }

    @ApiModelProperty(example="null", value="The structure for any SCO associated with this step")
    @JsonProperty(value="structure")
    public List<LearningAssignmentStepScoStructure> getStructure() {
        return this.structure;
    }

    @ApiModelProperty(example="null", value="The success status of this step")
    @JsonProperty(value="successStatus")
    public SuccessStatusEnum getSuccessStatus() {
        return this.successStatus;
    }

    @ApiModelProperty(example="null", value="The completion status of the assignment step")
    @JsonProperty(value="completionStatus")
    public CompletionStatusEnum getCompletionStatus() {
        return this.completionStatus;
    }

    public LearningAssignmentStep completionPercentage(Float completionPercentage) {
        this.completionPercentage = completionPercentage;
        return this;
    }

    @ApiModelProperty(example="null", value="The completion percentage for this step")
    @JsonProperty(value="completionPercentage")
    public Float getCompletionPercentage() {
        return this.completionPercentage;
    }

    public void setCompletionPercentage(Float completionPercentage) {
        this.completionPercentage = completionPercentage;
    }

    @ApiModelProperty(example="null", value="The percentage score for this step")
    @JsonProperty(value="percentageScore")
    public Float getPercentageScore() {
        return this.percentageScore;
    }

    public LearningAssignmentStep shareableContentObject(LearningShareableContentObject shareableContentObject) {
        this.shareableContentObject = shareableContentObject;
        return this;
    }

    @ApiModelProperty(example="null", value="The SCO (Shareable Content Object) data")
    @JsonProperty(value="shareableContentObject")
    public LearningShareableContentObject getShareableContentObject() {
        return this.shareableContentObject;
    }

    public void setShareableContentObject(LearningShareableContentObject shareableContentObject) {
        this.shareableContentObject = shareableContentObject;
    }

    @ApiModelProperty(example="null", value="The signed cookie information needed to access the content of this step (if required)")
    @JsonProperty(value="signedCookie")
    public LearningAssignmentStepSignedCookie getSignedCookie() {
        return this.signedCookie;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningAssignmentStep learningAssignmentStep = (LearningAssignmentStep)o;
        return Objects.equals(this.id, learningAssignmentStep.id) && Objects.equals(this.moduleStep, learningAssignmentStep.moduleStep) && Objects.equals(this.structure, learningAssignmentStep.structure) && Objects.equals((Object)this.successStatus, (Object)learningAssignmentStep.successStatus) && Objects.equals((Object)this.completionStatus, (Object)learningAssignmentStep.completionStatus) && Objects.equals(this.completionPercentage, learningAssignmentStep.completionPercentage) && Objects.equals(this.percentageScore, learningAssignmentStep.percentageScore) && Objects.equals(this.shareableContentObject, learningAssignmentStep.shareableContentObject) && Objects.equals(this.signedCookie, learningAssignmentStep.signedCookie) && Objects.equals(this.selfUri, learningAssignmentStep.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.moduleStep, this.structure, this.successStatus, this.completionStatus, this.completionPercentage, this.percentageScore, this.shareableContentObject, this.signedCookie, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningAssignmentStep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    moduleStep: ").append(this.toIndentedString(this.moduleStep)).append("\n");
        sb.append("    structure: ").append(this.toIndentedString(this.structure)).append("\n");
        sb.append("    successStatus: ").append(this.toIndentedString((Object)this.successStatus)).append("\n");
        sb.append("    completionStatus: ").append(this.toIndentedString((Object)this.completionStatus)).append("\n");
        sb.append("    completionPercentage: ").append(this.toIndentedString(this.completionPercentage)).append("\n");
        sb.append("    percentageScore: ").append(this.toIndentedString(this.percentageScore)).append("\n");
        sb.append("    shareableContentObject: ").append(this.toIndentedString(this.shareableContentObject)).append("\n");
        sb.append("    signedCookie: ").append(this.toIndentedString(this.signedCookie)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SuccessStatusEnumDeserializer.class)
    public static enum SuccessStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PASSED("Passed"),
        FAILED("Failed"),
        UNKNOWN("Unknown");

        private String value;

        private SuccessStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SuccessStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SuccessStatusEnum value : SuccessStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SuccessStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=CompletionStatusEnumDeserializer.class)
    public static enum CompletionStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMPLETED("Completed"),
        INCOMPLETE("Incomplete"),
        NOTATTEMPTED("NotAttempted"),
        UNKNOWN("Unknown");

        private String value;

        private CompletionStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CompletionStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CompletionStatusEnum value : CompletionStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CompletionStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CompletionStatusEnumDeserializer
    extends StdDeserializer<CompletionStatusEnum> {
        public CompletionStatusEnumDeserializer() {
            super(CompletionStatusEnumDeserializer.class);
        }

        public CompletionStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CompletionStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SuccessStatusEnumDeserializer
    extends StdDeserializer<SuccessStatusEnum> {
        public SuccessStatusEnumDeserializer() {
            super(SuccessStatusEnumDeserializer.class);
        }

        public SuccessStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SuccessStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

