/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.FeedbackAddRequest;
import java.util.HashMap;
import java.util.Map;

public class PostConversationSummaryFeedbackRequest {
    private String conversationId;
    private String summaryId;
    private FeedbackAddRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationSummaryFeedbackRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String summaryId) {
        this.summaryId = summaryId;
    }

    public PostConversationSummaryFeedbackRequest withSummaryId(String summaryId) {
        this.setSummaryId(summaryId);
        return this;
    }

    public FeedbackAddRequest getBody() {
        return this.body;
    }

    public void setBody(FeedbackAddRequest body) {
        this.body = body;
    }

    public PostConversationSummaryFeedbackRequest withBody(FeedbackAddRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationSummaryFeedbackRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<FeedbackAddRequest> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationSummaryFeedbackRequest.");
        }
        if (this.summaryId == null) {
            throw new IllegalStateException("Missing the required parameter 'summaryId' when building request for PostConversationSummaryFeedbackRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/{conversationId}/summaries/{summaryId}/feedback").withPathParameter("conversationId", this.conversationId).withPathParameter("summaryId", this.summaryId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String summaryId) {
        return new Builder().withRequiredParams(conversationId, summaryId);
    }

    public static class Builder {
        private final PostConversationSummaryFeedbackRequest request = new PostConversationSummaryFeedbackRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withSummaryId(String summaryId) {
            this.request.setSummaryId(summaryId);
            return this;
        }

        public Builder withBody(FeedbackAddRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String summaryId) {
            this.request.setConversationId(conversationId);
            this.request.setSummaryId(summaryId);
            return this;
        }

        public PostConversationSummaryFeedbackRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationSummaryFeedbackRequest.");
            }
            if (this.request.summaryId == null) {
                throw new IllegalStateException("Missing the required parameter 'summaryId' when building request for PostConversationSummaryFeedbackRequest.");
            }
            return this.request;
        }
    }
}

