/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetScimResourcetypeRequest {
    private String resourceType;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public GetScimResourcetypeRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScimResourcetypeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.resourceType == null) {
            throw new IllegalStateException("Missing the required parameter 'resourceType' when building request for GetScimResourcetypeRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scim/resourcetypes/{resourceType}").withPathParameter("resourceType", this.resourceType).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/scim+json", "application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String resourceType) {
        return new Builder().withRequiredParams(resourceType);
    }

    public static class Builder {
        private final GetScimResourcetypeRequest request = new GetScimResourcetypeRequest();

        private Builder() {
        }

        public Builder withResourceType(String resourceType) {
            this.request.setResourceType(resourceType);
            return this;
        }

        public Builder withResourceType(resourceTypeValues resourceType) {
            this.request.setResourceType(resourceType.toString());
            return this;
        }

        public Builder withRequiredParams(String resourceType) {
            this.request.setResourceType(resourceType);
            return this;
        }

        public GetScimResourcetypeRequest build() {
            if (this.request.resourceType == null) {
                throw new IllegalStateException("Missing the required parameter 'resourceType' when building request for GetScimResourcetypeRequest.");
            }
            return this.request;
        }
    }

    public static enum resourceTypeValues {
        USER("User"),
        GROUP("Group"),
        SERVICEPROVIDERCONFIG("ServiceProviderConfig"),
        RESOURCETYPE("ResourceType"),
        SCHEMA("Schema");

        private String value;

        private resourceTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static resourceTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (resourceTypeValues value : resourceTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return resourceTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

