/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.WorkPlanValidationMessageArgument;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkPlanConfigurationViolationMessage
implements Serializable {
    private TypeEnum type = null;
    private List<WorkPlanValidationMessageArgument> arguments = new ArrayList<WorkPlanValidationMessageArgument>();
    private SeverityEnum severity = null;

    public WorkPlanConfigurationViolationMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of configuration violation message for this work plan")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WorkPlanConfigurationViolationMessage arguments(List<WorkPlanValidationMessageArgument> arguments) {
        this.arguments = arguments;
        return this;
    }

    @ApiModelProperty(example="null", value="Arguments of the message that provide information about the misconfigured value or the threshold that is exceeded by the misconfigured value")
    @JsonProperty(value="arguments")
    public List<WorkPlanValidationMessageArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<WorkPlanValidationMessageArgument> arguments) {
        this.arguments = arguments;
    }

    public WorkPlanConfigurationViolationMessage severity(SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @ApiModelProperty(example="null", value="Severity of the message. A message with Error severity indicates the scheduler won't be able to produce schedules and thus the work plan is invalid.")
    @JsonProperty(value="severity")
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkPlanConfigurationViolationMessage workPlanConfigurationViolationMessage = (WorkPlanConfigurationViolationMessage)o;
        return Objects.equals((Object)this.type, (Object)workPlanConfigurationViolationMessage.type) && Objects.equals(this.arguments, workPlanConfigurationViolationMessage.arguments) && Objects.equals((Object)this.severity, (Object)workPlanConfigurationViolationMessage.severity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.arguments, this.severity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkPlanConfigurationViolationMessage {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVITIESOVERLAP("ActivitiesOverlap"),
        ACTIVITYENDGREATERTHANSHIFTSTOP("ActivityEndGreaterThanShiftStop"),
        ACTIVITYPAIDTIMEGREATERTHANSHIFTPAIDTIME("ActivityPaidTimeGreaterThanShiftPaidTime"),
        ACTIVITYSTARTBEFORESHIFTSTART("ActivityStartBeforeShiftStart"),
        ACTIVITYSTARTGREATERTHANEQUALTOSHIFTSTOP("ActivityStartGreaterThanEqualToShiftStop"),
        ACTIVITYSTARTINCREMENTMINUTESNOTDIVISIBLEBYSCHEDULEINTERVALMINUTES("ActivityStartIncrementMinutesNotDivisibleByScheduleIntervalMinutes"),
        DAILYEXACTPAIDMINUTES("DailyExactPaidMinutes"),
        DAILYMAXTOTALLESSTHANWEEKLYMIN("DailyMaxTotalLessThanWeeklyMin"),
        DAILYMAXTOTALLESSTHANWEEKLYMINWITHOPTIONAL("DailyMaxTotalLessThanWeeklyMinWithOptional"),
        DAILYMAXTOTALLESSTHANWEEKLYMINWITHOUTOPTIONAL("DailyMaxTotalLessThanWeeklyMinWithoutOptional"),
        DAILYMINTOTALGREATERTHANWEEKLYMAX("DailyMinTotalGreaterThanWeeklyMax"),
        DAILYMINTOTALGREATERTHANWEEKLYMAXWITHOPTIONAL("DailyMinTotalGreaterThanWeeklyMaxWithOptional"),
        DAILYMINTOTALGREATERTHANWEEKLYMAXWITHOUTOPTIONAL("DailyMinTotalGreaterThanWeeklyMaxWithoutOptional"),
        DAILYREQUIREDDAYSGREATERTHANWEEKLYMAXDAYS("DailyRequiredDaysGreaterThanWeeklyMaxDays"),
        DAILYSHIFTHASNODAYSSELECTED("DailyShiftHasNoDaysSelected"),
        DAILYSHIFTMAXPOSSIBILITIESVIOLATED("DailyShiftMaxPossibilitiesViolated"),
        EARLIESTSHIFTSTOPISTOOLATE("EarliestShiftStopIsTooLate"),
        EXACTPAIDTIMENOTDIVISIBLEBYGRANULARITY("ExactPaidTimeNotDivisibleByGranularity"),
        MAXCONSECUTIVEWORKINGDAYSNOMORETHANDOUBLEMAXWORKINGDAYSPERWEEK("MaxConsecutiveWorkingDaysNoMoreThanDoubleMaxWorkingDaysPerWeek"),
        MAXDAYSOFFPERPLANNINGPERIODNOTCORRECT("MaxDaysOffPerPlanningPeriodNotCorrect"),
        MAXPAIDTIMEISMORETHANSHIFTLENGTH("MaxPaidTimeIsMoreThanShiftLength"),
        MAXPAIDTIMENOTDIVISIBLEBYGRANULARITY("MaxPaidTimeNotDivisibleByGranularity"),
        MAXPAIDTIMEPERPLANNINGPERIOD("MaxPaidTimePerPlanningPeriod"),
        MAXSHIFTS("MaxShifts"),
        MINPAIDTIMENOTDIVISIBLEBYGRANULARITY("MinPaidTimeNotDivisibleByGranularity"),
        MINPAIDTIMEPERPLANNINGPERIOD("MinPaidTimePerPlanningPeriod"),
        NOSHIFTS("NoShifts"),
        PAIDTIMEGREATERTHANMAXWORKTIME("PaidTimeGreaterThanMaxWorkTime"),
        PAIDTIMELESSTHANMINWORKTIME("PaidTimeLessThanMinWorkTime"),
        PAIDTIMENOTMETBYSHIFTSTARTSTOP("PaidTimeNotMetByShiftStartStop"),
        SHIFTDAYSSELECTMORETHANMINWORKINGDAYS("ShiftDaysSelectMoreThanMinWorkingDays"),
        SHIFTSTOPEARLIERTHANSTART("ShiftStopEarlierThanStart"),
        SHIFTVARIANCECANNOTBEMET("ShiftVarianceCannotBeMet"),
        WEEKLYEXACTPAIDMINUTES("WeeklyExactPaidMinutes");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SeverityEnumDeserializer.class)
    public static enum SeverityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INFORMATION("Information"),
        WARNING("Warning"),
        ERROR("Error");

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SeverityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SeverityEnum value : SeverityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SeverityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SeverityEnumDeserializer
    extends StdDeserializer<SeverityEnum> {
        public SeverityEnumDeserializer() {
            super(SeverityEnumDeserializer.class);
        }

        public SeverityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SeverityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

