/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.EmpathyScore;
import com.mypurecloud.sdk.v2.model.ParticipantMetrics;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConversationMetrics
implements Serializable {
    private AddressableEntityRef conversation = null;
    private Double sentimentScore = null;
    private Double sentimentTrend = null;
    private SentimentTrendClassEnum sentimentTrendClass = null;
    private List<EmpathyScore> empathyScores = new ArrayList<EmpathyScore>();
    private ParticipantMetrics participantMetrics = null;

    public ConversationMetrics conversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", value="The Conversation Reference")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    public void setConversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
    }

    public ConversationMetrics sentimentScore(Double sentimentScore) {
        this.sentimentScore = sentimentScore;
        return this;
    }

    @ApiModelProperty(example="null", value="The Sentiment Score")
    @JsonProperty(value="sentimentScore")
    public Double getSentimentScore() {
        return this.sentimentScore;
    }

    public void setSentimentScore(Double sentimentScore) {
        this.sentimentScore = sentimentScore;
    }

    public ConversationMetrics sentimentTrend(Double sentimentTrend) {
        this.sentimentTrend = sentimentTrend;
        return this;
    }

    @ApiModelProperty(example="null", value="The Sentiment Trend")
    @JsonProperty(value="sentimentTrend")
    public Double getSentimentTrend() {
        return this.sentimentTrend;
    }

    public void setSentimentTrend(Double sentimentTrend) {
        this.sentimentTrend = sentimentTrend;
    }

    public ConversationMetrics sentimentTrendClass(SentimentTrendClassEnum sentimentTrendClass) {
        this.sentimentTrendClass = sentimentTrendClass;
        return this;
    }

    @ApiModelProperty(example="null", value="The Sentiment Trend Class")
    @JsonProperty(value="sentimentTrendClass")
    public SentimentTrendClassEnum getSentimentTrendClass() {
        return this.sentimentTrendClass;
    }

    public void setSentimentTrendClass(SentimentTrendClassEnum sentimentTrendClass) {
        this.sentimentTrendClass = sentimentTrendClass;
    }

    public ConversationMetrics empathyScores(List<EmpathyScore> empathyScores) {
        this.empathyScores = empathyScores;
        return this;
    }

    @ApiModelProperty(example="null", value="The Empathy Scores")
    @JsonProperty(value="empathyScores")
    public List<EmpathyScore> getEmpathyScores() {
        return this.empathyScores;
    }

    public void setEmpathyScores(List<EmpathyScore> empathyScores) {
        this.empathyScores = empathyScores;
    }

    public ConversationMetrics participantMetrics(ParticipantMetrics participantMetrics) {
        this.participantMetrics = participantMetrics;
        return this;
    }

    @ApiModelProperty(example="null", value="The Participant Metrics")
    @JsonProperty(value="participantMetrics")
    public ParticipantMetrics getParticipantMetrics() {
        return this.participantMetrics;
    }

    public void setParticipantMetrics(ParticipantMetrics participantMetrics) {
        this.participantMetrics = participantMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMetrics conversationMetrics = (ConversationMetrics)o;
        return Objects.equals(this.conversation, conversationMetrics.conversation) && Objects.equals(this.sentimentScore, conversationMetrics.sentimentScore) && Objects.equals(this.sentimentTrend, conversationMetrics.sentimentTrend) && Objects.equals((Object)this.sentimentTrendClass, (Object)conversationMetrics.sentimentTrendClass) && Objects.equals(this.empathyScores, conversationMetrics.empathyScores) && Objects.equals(this.participantMetrics, conversationMetrics.participantMetrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversation, this.sentimentScore, this.sentimentTrend, this.sentimentTrendClass, this.empathyScores, this.participantMetrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMetrics {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    sentimentScore: ").append(this.toIndentedString(this.sentimentScore)).append("\n");
        sb.append("    sentimentTrend: ").append(this.toIndentedString(this.sentimentTrend)).append("\n");
        sb.append("    sentimentTrendClass: ").append(this.toIndentedString((Object)this.sentimentTrendClass)).append("\n");
        sb.append("    empathyScores: ").append(this.toIndentedString(this.empathyScores)).append("\n");
        sb.append("    participantMetrics: ").append(this.toIndentedString(this.participantMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SentimentTrendClassEnumDeserializer.class)
    public static enum SentimentTrendClassEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOTCALCULATED("NotCalculated"),
        DECLINING("Declining"),
        SLIGHTLYDECLINING("SlightlyDeclining"),
        NOCHANGE("NoChange"),
        SLIGHTLYIMPROVING("SlightlyImproving"),
        IMPROVING("Improving");

        private String value;

        private SentimentTrendClassEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SentimentTrendClassEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SentimentTrendClassEnum value : SentimentTrendClassEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SentimentTrendClassEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SentimentTrendClassEnumDeserializer
    extends StdDeserializer<SentimentTrendClassEnum> {
        public SentimentTrendClassEnumDeserializer() {
            super(SentimentTrendClassEnumDeserializer.class);
        }

        public SentimentTrendClassEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SentimentTrendClassEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

