/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.WritableEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostRoutingQueueUsersRequest {
    private String queueId;
    private List<WritableEntity> body;
    private Boolean delete;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PostRoutingQueueUsersRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public List<WritableEntity> getBody() {
        return this.body;
    }

    public void setBody(List<WritableEntity> body) {
        this.body = body;
    }

    public PostRoutingQueueUsersRequest withBody(List<WritableEntity> body) {
        this.setBody(body);
        return this;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public PostRoutingQueueUsersRequest withDelete(Boolean delete) {
        this.setDelete(delete);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostRoutingQueueUsersRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<WritableEntity>> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostRoutingQueueUsersRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostRoutingQueueUsersRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/routing/queues/{queueId}/users").withPathParameter("queueId", this.queueId).withQueryParameters("delete", "", this.delete).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, List<WritableEntity> body) {
        return new Builder().withRequiredParams(queueId, body);
    }

    public static class Builder {
        private final PostRoutingQueueUsersRequest request = new PostRoutingQueueUsersRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(List<WritableEntity> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withDelete(Boolean delete) {
            this.request.setDelete(delete);
            return this;
        }

        public Builder withRequiredParams(String queueId, List<WritableEntity> body) {
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PostRoutingQueueUsersRequest build() {
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostRoutingQueueUsersRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostRoutingQueueUsersRequest.");
            }
            return this.request;
        }
    }
}

