/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationParticipantWrapupRequest {
    private String conversationId;
    private String participantId;
    private Boolean provisional;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationParticipantWrapupRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public GetConversationParticipantWrapupRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public Boolean getProvisional() {
        return this.provisional;
    }

    public void setProvisional(Boolean provisional) {
        this.provisional = provisional;
    }

    public GetConversationParticipantWrapupRequest withProvisional(Boolean provisional) {
        this.setProvisional(provisional);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationParticipantWrapupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationParticipantWrapupRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for GetConversationParticipantWrapupRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/{conversationId}/participants/{participantId}/wrapup").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withQueryParameters("provisional", "", this.provisional).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId) {
        return new Builder().withRequiredParams(conversationId, participantId);
    }

    public static class Builder {
        private final GetConversationParticipantWrapupRequest request = new GetConversationParticipantWrapupRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withProvisional(Boolean provisional) {
            this.request.setProvisional(provisional);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            return this;
        }

        public GetConversationParticipantWrapupRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationParticipantWrapupRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for GetConversationParticipantWrapupRequest.");
            }
            return this.request;
        }
    }
}

