/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetChatsRoomMessageRequest {
    private String roomJid;
    private String messageIds;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public GetChatsRoomMessageRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public String getMessageIds() {
        return this.messageIds;
    }

    public void setMessageIds(String messageIds) {
        this.messageIds = messageIds;
    }

    public GetChatsRoomMessageRequest withMessageIds(String messageIds) {
        this.setMessageIds(messageIds);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetChatsRoomMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for GetChatsRoomMessageRequest.");
        }
        if (this.messageIds == null) {
            throw new IllegalStateException("Missing the required parameter 'messageIds' when building request for GetChatsRoomMessageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/chats/rooms/{roomJid}/messages/{messageIds}").withPathParameter("roomJid", this.roomJid).withPathParameter("messageIds", this.messageIds).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, String messageIds) {
        return new Builder().withRequiredParams(roomJid, messageIds);
    }

    public static class Builder {
        private final GetChatsRoomMessageRequest request = new GetChatsRoomMessageRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withMessageIds(String messageIds) {
            this.request.setMessageIds(messageIds);
            return this;
        }

        public Builder withRequiredParams(String roomJid, String messageIds) {
            this.request.setRoomJid(roomJid);
            this.request.setMessageIds(messageIds);
            return this;
        }

        public GetChatsRoomMessageRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for GetChatsRoomMessageRequest.");
            }
            if (this.request.messageIds == null) {
                throw new IllegalStateException("Missing the required parameter 'messageIds' when building request for GetChatsRoomMessageRequest.");
            }
            return this.request;
        }
    }
}

