/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.WebChatConversation;
import com.mypurecloud.sdk.v2.model.WebChatMemberInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class WebChatMessage
implements Serializable {
    private String id = null;
    private String name = null;
    private WebChatConversation conversation = null;
    private WebChatMemberInfo sender = null;
    private String body = null;
    private BodyTypeEnum bodyType = null;
    private Date timestamp = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WebChatMessage name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebChatMessage conversation(WebChatConversation conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The identifier of the conversation")
    @JsonProperty(value="conversation")
    public WebChatConversation getConversation() {
        return this.conversation;
    }

    public void setConversation(WebChatConversation conversation) {
        this.conversation = conversation;
    }

    public WebChatMessage sender(WebChatMemberInfo sender) {
        this.sender = sender;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The member who sent the message")
    @JsonProperty(value="sender")
    public WebChatMemberInfo getSender() {
        return this.sender;
    }

    public void setSender(WebChatMemberInfo sender) {
        this.sender = sender;
    }

    public WebChatMessage body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The message body.")
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public WebChatMessage bodyType(BodyTypeEnum bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The purpose of the message within the conversation, such as a standard text entry versus a greeting.")
    @JsonProperty(value="bodyType")
    public BodyTypeEnum getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyTypeEnum bodyType) {
        this.bodyType = bodyType;
    }

    public WebChatMessage timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The timestamp of the message, in ISO-8601 format")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebChatMessage webChatMessage = (WebChatMessage)o;
        return Objects.equals(this.id, webChatMessage.id) && Objects.equals(this.name, webChatMessage.name) && Objects.equals(this.conversation, webChatMessage.conversation) && Objects.equals(this.sender, webChatMessage.sender) && Objects.equals(this.body, webChatMessage.body) && Objects.equals((Object)this.bodyType, (Object)webChatMessage.bodyType) && Objects.equals(this.timestamp, webChatMessage.timestamp) && Objects.equals(this.selfUri, webChatMessage.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.conversation, this.sender, this.body, this.bodyType, this.timestamp, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebChatMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    bodyType: ").append(this.toIndentedString((Object)this.bodyType)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=BodyTypeEnumDeserializer.class)
    public static enum BodyTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STANDARD("standard"),
        NOTICE("notice"),
        MEMBER_JOIN("member-join"),
        MEMBER_LEAVE("member-leave"),
        MEDIA_REQUEST("media-request");

        private String value;

        private BodyTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BodyTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BodyTypeEnum value : BodyTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BodyTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BodyTypeEnumDeserializer
    extends StdDeserializer<BodyTypeEnum> {
        public BodyTypeEnumDeserializer() {
            super(BodyTypeEnumDeserializer.class);
        }

        public BodyTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BodyTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

