/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.okhttp;

import com.mypurecloud.sdk.v2.connector.ApiClientConnector;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperties;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperty;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProvider;
import com.mypurecloud.sdk.v2.connector.okhttp.OkHttpClientConnector;
import java.net.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class OkHttpClientConnectorProvider
implements ApiClientConnectorProvider {
    @Override
    public ApiClientConnector create(ApiClientConnectorProperties properties) {
        ExecutorService executorService;
        Proxy proxy;
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        Integer connectionTimeout = properties.getProperty(ApiClientConnectorProperty.CONNECTION_TIMEOUT, Integer.class, null);
        if (connectionTimeout != null && connectionTimeout > 0) {
            builder.connectTimeout((long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS);
            builder.readTimeout((long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS);
            builder.writeTimeout((long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if ((proxy = (Proxy)properties.getProperty(ApiClientConnectorProperty.PROXY, Proxy.class, null)) != null) {
            builder.proxy(proxy);
        }
        if ((executorService = (ExecutorService)properties.getProperty(ApiClientConnectorProperty.ASYNC_EXECUTOR_SERVICE, ExecutorService.class, null)) != null) {
            builder.dispatcher(new Dispatcher(executorService));
        }
        return new OkHttpClientConnector(builder.build());
    }
}

