/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ScimV2Group;
import java.util.HashMap;
import java.util.Map;

public class PutScimV2GroupRequest {
    private String groupId;
    private ScimV2Group body;
    private String ifMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public PutScimV2GroupRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public ScimV2Group getBody() {
        return this.body;
    }

    public void setBody(ScimV2Group body) {
        this.body = body;
    }

    public PutScimV2GroupRequest withBody(ScimV2Group body) {
        this.setBody(body);
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public PutScimV2GroupRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutScimV2GroupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ScimV2Group> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PutScimV2GroupRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutScimV2GroupRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/scim/v2/groups/{groupId}").withPathParameter("groupId", this.groupId).withHeaderParameter("If-Match", this.ifMatch).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/scim+json", "application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId, ScimV2Group body) {
        return new Builder().withRequiredParams(groupId, body);
    }

    public static class Builder {
        private final PutScimV2GroupRequest request = new PutScimV2GroupRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withBody(ScimV2Group body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withIfMatch(String ifMatch) {
            this.request.setIfMatch(ifMatch);
            return this;
        }

        public Builder withRequiredParams(String groupId, ScimV2Group body) {
            this.request.setGroupId(groupId);
            this.request.setBody(body);
            return this;
        }

        public PutScimV2GroupRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PutScimV2GroupRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutScimV2GroupRequest.");
            }
            return this.request;
        }
    }
}

