/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Room
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private RoomTypeEnum roomType = null;
    private String description = null;
    private Integer participantLimit = null;
    private List<UserReference> owners = new ArrayList<UserReference>();
    private List<AddressableEntityRef> pinnedMessages = new ArrayList<AddressableEntityRef>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The jid of the room")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Room name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Room dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Room's created time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Room roomType(RoomTypeEnum roomType) {
        this.roomType = roomType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of room")
    @JsonProperty(value="roomType")
    public RoomTypeEnum getRoomType() {
        return this.roomType;
    }

    public void setRoomType(RoomTypeEnum roomType) {
        this.roomType = roomType;
    }

    public Room description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Room's description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Room participantLimit(Integer participantLimit) {
        this.participantLimit = participantLimit;
        return this;
    }

    @ApiModelProperty(example="null", value="Room's size limit")
    @JsonProperty(value="participantLimit")
    public Integer getParticipantLimit() {
        return this.participantLimit;
    }

    public void setParticipantLimit(Integer participantLimit) {
        this.participantLimit = participantLimit;
    }

    public Room owners(List<UserReference> owners) {
        this.owners = owners;
        return this;
    }

    @ApiModelProperty(example="null", value="Room's owners")
    @JsonProperty(value="owners")
    public List<UserReference> getOwners() {
        return this.owners;
    }

    public void setOwners(List<UserReference> owners) {
        this.owners = owners;
    }

    public Room pinnedMessages(List<AddressableEntityRef> pinnedMessages) {
        this.pinnedMessages = pinnedMessages;
        return this;
    }

    @ApiModelProperty(example="null", value="Room's pinned messages")
    @JsonProperty(value="pinnedMessages")
    public List<AddressableEntityRef> getPinnedMessages() {
        return this.pinnedMessages;
    }

    public void setPinnedMessages(List<AddressableEntityRef> pinnedMessages) {
        this.pinnedMessages = pinnedMessages;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Room room = (Room)o;
        return Objects.equals(this.id, room.id) && Objects.equals(this.name, room.name) && Objects.equals(this.dateCreated, room.dateCreated) && Objects.equals((Object)this.roomType, (Object)room.roomType) && Objects.equals(this.description, room.description) && Objects.equals(this.participantLimit, room.participantLimit) && Objects.equals(this.owners, room.owners) && Objects.equals(this.pinnedMessages, room.pinnedMessages) && Objects.equals(this.selfUri, room.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.roomType, this.description, this.participantLimit, this.owners, this.pinnedMessages, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Room {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    roomType: ").append(this.toIndentedString((Object)this.roomType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    participantLimit: ").append(this.toIndentedString(this.participantLimit)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    pinnedMessages: ").append(this.toIndentedString(this.pinnedMessages)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RoomTypeEnumDeserializer.class)
    public static enum RoomTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ADHOC("adhoc"),
        ACD("acd"),
        GROUP("group"),
        ONEONONE("oneOnOne"),
        SUPERVISORASSISTANCE("supervisorAssistance");

        private String value;

        private RoomTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RoomTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RoomTypeEnum value : RoomTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RoomTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RoomTypeEnumDeserializer
    extends StdDeserializer<RoomTypeEnum> {
        public RoomTypeEnumDeserializer() {
            super(RoomTypeEnumDeserializer.class);
        }

        public RoomTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RoomTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

