/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DivisionReference;
import com.mypurecloud.sdk.v2.model.InsightsAgentItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InsightsAgents
implements Serializable {
    private AddressableEntityRef performanceProfile = null;
    private DivisionReference division = null;
    private GranularityEnum granularity = null;
    private LocalDate dateStartWorkday = null;
    private LocalDate dateEndWorkday = null;
    private List<InsightsAgentItem> entities = new ArrayList<InsightsAgentItem>();

    public InsightsAgents performanceProfile(AddressableEntityRef performanceProfile) {
        this.performanceProfile = performanceProfile;
        return this;
    }

    @ApiModelProperty(example="null", value="The performance profile")
    @JsonProperty(value="performanceProfile")
    public AddressableEntityRef getPerformanceProfile() {
        return this.performanceProfile;
    }

    public void setPerformanceProfile(AddressableEntityRef performanceProfile) {
        this.performanceProfile = performanceProfile;
    }

    public InsightsAgents division(DivisionReference division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division")
    @JsonProperty(value="division")
    public DivisionReference getDivision() {
        return this.division;
    }

    public void setDivision(DivisionReference division) {
        this.division = division;
    }

    public InsightsAgents granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public InsightsAgents dateStartWorkday(LocalDate dateStartWorkday) {
        this.dateStartWorkday = dateStartWorkday;
        return this;
    }

    @ApiModelProperty(example="null", value="Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStartWorkday")
    public LocalDate getDateStartWorkday() {
        return this.dateStartWorkday;
    }

    public void setDateStartWorkday(LocalDate dateStartWorkday) {
        this.dateStartWorkday = dateStartWorkday;
    }

    public InsightsAgents dateEndWorkday(LocalDate dateEndWorkday) {
        this.dateEndWorkday = dateEndWorkday;
        return this;
    }

    @ApiModelProperty(example="null", value="End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEndWorkday")
    public LocalDate getDateEndWorkday() {
        return this.dateEndWorkday;
    }

    public void setDateEndWorkday(LocalDate dateEndWorkday) {
        this.dateEndWorkday = dateEndWorkday;
    }

    public InsightsAgents entities(List<InsightsAgentItem> entities) {
        this.entities = entities;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of insights agents")
    @JsonProperty(value="entities")
    public List<InsightsAgentItem> getEntities() {
        return this.entities;
    }

    public void setEntities(List<InsightsAgentItem> entities) {
        this.entities = entities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsAgents insightsAgents = (InsightsAgents)o;
        return Objects.equals(this.performanceProfile, insightsAgents.performanceProfile) && Objects.equals(this.division, insightsAgents.division) && Objects.equals((Object)this.granularity, (Object)insightsAgents.granularity) && Objects.equals(this.dateStartWorkday, insightsAgents.dateStartWorkday) && Objects.equals(this.dateEndWorkday, insightsAgents.dateEndWorkday) && Objects.equals(this.entities, insightsAgents.entities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.performanceProfile, this.division, this.granularity, this.dateStartWorkday, this.dateEndWorkday, this.entities});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsightsAgents {\n");
        sb.append("    performanceProfile: ").append(this.toIndentedString(this.performanceProfile)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    dateStartWorkday: ").append(this.toIndentedString(this.dateStartWorkday)).append("\n");
        sb.append("    dateEndWorkday: ").append(this.toIndentedString(this.dateEndWorkday)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily"),
        WEEKLY("Weekly"),
        MONTHLY("Monthly");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

