/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetLearningModuleJobRequest {
    private String moduleId;
    private String jobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public GetLearningModuleJobRequest withModuleId(String moduleId) {
        this.setModuleId(moduleId);
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public GetLearningModuleJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetLearningModuleJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.moduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for GetLearningModuleJobRequest.");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetLearningModuleJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/learning/modules/{moduleId}/jobs/{jobId}").withPathParameter("moduleId", this.moduleId).withPathParameter("jobId", this.jobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String moduleId, String jobId) {
        return new Builder().withRequiredParams(moduleId, jobId);
    }

    public static class Builder {
        private final GetLearningModuleJobRequest request = new GetLearningModuleJobRequest();

        private Builder() {
        }

        public Builder withModuleId(String moduleId) {
            this.request.setModuleId(moduleId);
            return this;
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withRequiredParams(String moduleId, String jobId) {
            this.request.setModuleId(moduleId);
            this.request.setJobId(jobId);
            return this;
        }

        public GetLearningModuleJobRequest build() {
            if (this.request.moduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for GetLearningModuleJobRequest.");
            }
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetLearningModuleJobRequest.");
            }
            return this.request;
        }
    }
}

