/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.TrustUserCreate;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TrustCreate
implements Serializable {
    private String pairingId = null;
    private Boolean enabled = null;
    private List<TrustUserCreate> users = new ArrayList<TrustUserCreate>();

    public TrustCreate pairingId(String pairingId) {
        this.pairingId = pairingId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The pairing Id created by the trustee. This is required to prove that the trustee agrees to the relationship.")
    @JsonProperty(value="pairingId")
    public String getPairingId() {
        return this.pairingId;
    }

    public void setPairingId(String pairingId) {
        this.pairingId = pairingId;
    }

    public TrustCreate enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="If disabled no trustee user will have access, even if they were previously added.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TrustCreate users(List<TrustUserCreate> users) {
        this.users = users;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of users and their roles to which access will be granted. The users are from the trustee and the roles are from the trustor.")
    @JsonProperty(value="users")
    public List<TrustUserCreate> getUsers() {
        return this.users;
    }

    public void setUsers(List<TrustUserCreate> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustCreate trustCreate = (TrustCreate)o;
        return Objects.equals(this.pairingId, trustCreate.pairingId) && Objects.equals(this.enabled, trustCreate.enabled) && Objects.equals(this.users, trustCreate.users);
    }

    public int hashCode() {
        return Objects.hash(this.pairingId, this.enabled, this.users);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustCreate {\n");
        sb.append("    pairingId: ").append(this.toIndentedString(this.pairingId)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

