/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Grammar;
import java.util.HashMap;
import java.util.Map;

public class PatchArchitectGrammarRequest {
    private String grammarId;
    private Grammar body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGrammarId() {
        return this.grammarId;
    }

    public void setGrammarId(String grammarId) {
        this.grammarId = grammarId;
    }

    public PatchArchitectGrammarRequest withGrammarId(String grammarId) {
        this.setGrammarId(grammarId);
        return this;
    }

    public Grammar getBody() {
        return this.body;
    }

    public void setBody(Grammar body) {
        this.body = body;
    }

    public PatchArchitectGrammarRequest withBody(Grammar body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchArchitectGrammarRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Grammar> withHttpInfo() {
        if (this.grammarId == null) {
            throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PatchArchitectGrammarRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/architect/grammars/{grammarId}").withPathParameter("grammarId", this.grammarId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String grammarId) {
        return new Builder().withRequiredParams(grammarId);
    }

    public static class Builder {
        private final PatchArchitectGrammarRequest request = new PatchArchitectGrammarRequest();

        private Builder() {
        }

        public Builder withGrammarId(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public Builder withBody(Grammar body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public PatchArchitectGrammarRequest build() {
            if (this.request.grammarId == null) {
                throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PatchArchitectGrammarRequest.");
            }
            return this.request;
        }
    }
}

