/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Address;
import com.mypurecloud.sdk.v2.model.ConversationRoutingData;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.JourneyContext;
import com.mypurecloud.sdk.v2.model.MessageDetails;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MessageMediaParticipant
implements Serializable {
    private String id = null;
    private String name = null;
    private String address = null;
    private Date startTime = null;
    private Date connectedTime = null;
    private Date endTime = null;
    private Date startHoldTime = null;
    private String purpose = null;
    private StateEnum state = null;
    private DirectionEnum direction = null;
    private DisconnectTypeEnum disconnectType = null;
    private Boolean held = null;
    private Boolean wrapupRequired = null;
    private String wrapupPrompt = null;
    private List<String> mediaRoles = new ArrayList<String>();
    private DomainEntityRef user = null;
    private DomainEntityRef queue = null;
    private DomainEntityRef team = null;
    private Map<String, String> attributes = null;
    private ErrorInfo errorInfo = null;
    private DomainEntityRef script = null;
    private Integer wrapupTimeoutMs = null;
    private Boolean wrapupSkipped = null;
    private Integer alertingTimeoutMs = null;
    private String provider = null;
    private DomainEntityRef externalContact = null;
    private DomainEntityRef externalOrganization = null;
    private Wrapup wrapup = null;
    private String peer = null;
    private FlaggedReasonEnum flaggedReason = null;
    private JourneyContext journeyContext = null;
    private ConversationRoutingData conversationRoutingData = null;
    private Date startAcwTime = null;
    private Date endAcwTime = null;
    private Address toAddress = null;
    private Address fromAddress = null;
    private List<MessageDetails> messages = new ArrayList<MessageDetails>();
    private TypeEnum type = null;
    private String recipientCountry = null;
    private String recipientType = null;
    private Boolean authenticated = null;
    private String monitoredParticipantId = null;

    public MessageMediaParticipant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique participant ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MessageMediaParticipant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The display friendly name of the participant.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MessageMediaParticipant address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant address.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public MessageMediaParticipant startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public MessageMediaParticipant connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public MessageMediaParticipant endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public MessageMediaParticipant startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public MessageMediaParticipant purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr")
    @JsonProperty(value="purpose")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public MessageMediaParticipant state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public MessageMediaParticipant direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's direction.  Values can be: 'inbound' or 'outbound'")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public MessageMediaParticipant disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the participant was disconnected from the conversation.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public MessageMediaParticipant held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant is on hold.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public MessageMediaParticipant wrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant requires wrap-up.")
    @JsonProperty(value="wrapupRequired")
    public Boolean getWrapupRequired() {
        return this.wrapupRequired;
    }

    public void setWrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
    }

    public MessageMediaParticipant wrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The wrap-up prompt indicating the type of wrap-up to be performed.")
    @JsonProperty(value="wrapupPrompt")
    public String getWrapupPrompt() {
        return this.wrapupPrompt;
    }

    public void setWrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
    }

    public MessageMediaParticipant mediaRoles(List<String> mediaRoles) {
        this.mediaRoles = mediaRoles;
        return this;
    }

    @ApiModelProperty(example="null", value="List of roles this participant's media has had on the conversation, ie monitor, coach, etc")
    @JsonProperty(value="mediaRoles")
    public List<String> getMediaRoles() {
        return this.mediaRoles;
    }

    public void setMediaRoles(List<String> mediaRoles) {
        this.mediaRoles = mediaRoles;
    }

    public MessageMediaParticipant user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user for this participant.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public MessageMediaParticipant queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud queue for this participant.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public MessageMediaParticipant team(DomainEntityRef team) {
        this.team = team;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud team for this participant.")
    @JsonProperty(value="team")
    public DomainEntityRef getTeam() {
        return this.team;
    }

    public void setTeam(DomainEntityRef team) {
        this.team = team;
    }

    public MessageMediaParticipant attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of ad-hoc attributes for the participant.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public MessageMediaParticipant errorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="If the conversation ends in error, contains additional error details.")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public MessageMediaParticipant script(DomainEntityRef script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", value="The Engage script that should be used by this participant.")
    @JsonProperty(value="script")
    public DomainEntityRef getScript() {
        return this.script;
    }

    public void setScript(DomainEntityRef script) {
        this.script = script;
    }

    public MessageMediaParticipant wrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time the participant has to complete wrap-up.")
    @JsonProperty(value="wrapupTimeoutMs")
    public Integer getWrapupTimeoutMs() {
        return this.wrapupTimeoutMs;
    }

    public void setWrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
    }

    public MessageMediaParticipant wrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant has skipped wrap-up.")
    @JsonProperty(value="wrapupSkipped")
    public Boolean getWrapupSkipped() {
        return this.wrapupSkipped;
    }

    public void setWrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
    }

    public MessageMediaParticipant alertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies how long the agent has to answer an interaction before being marked as not responding.")
    @JsonProperty(value="alertingTimeoutMs")
    public Integer getAlertingTimeoutMs() {
        return this.alertingTimeoutMs;
    }

    public void setAlertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
    }

    public MessageMediaParticipant provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the communication.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public MessageMediaParticipant externalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external contact, then this will be the reference for the external contact.")
    @JsonProperty(value="externalContact")
    public DomainEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public MessageMediaParticipant externalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external org, then this will be the reference for the external org.")
    @JsonProperty(value="externalOrganization")
    public DomainEntityRef getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public MessageMediaParticipant wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Wrapup for this participant, if it has been applied.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public MessageMediaParticipant peer(String peer) {
        this.peer = peer;
        return this;
    }

    @ApiModelProperty(example="null", value="The peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peer")
    public String getPeer() {
        return this.peer;
    }

    public void setPeer(String peer) {
        this.peer = peer;
    }

    public MessageMediaParticipant flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason specifying why participant flagged the conversation.")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public MessageMediaParticipant journeyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.")
    @JsonProperty(value="journeyContext")
    public JourneyContext getJourneyContext() {
        return this.journeyContext;
    }

    public void setJourneyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
    }

    public MessageMediaParticipant conversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on how a communication should be routed to an agent.")
    @JsonProperty(value="conversationRoutingData")
    public ConversationRoutingData getConversationRoutingData() {
        return this.conversationRoutingData;
    }

    public void setConversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
    }

    public MessageMediaParticipant startAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAcwTime")
    public Date getStartAcwTime() {
        return this.startAcwTime;
    }

    public void setStartAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
    }

    public MessageMediaParticipant endAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endAcwTime")
    public Date getEndAcwTime() {
        return this.endAcwTime;
    }

    public void setEndAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
    }

    public MessageMediaParticipant toAddress(Address toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Address for the participant on receiving side of the message conversation. If the address is a phone number, E.164 format is recommended.")
    @JsonProperty(value="toAddress")
    public Address getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public MessageMediaParticipant fromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Address for the participant on the sending side of the message conversation. If the address is a phone number, E.164 format is recommended.")
    @JsonProperty(value="fromAddress")
    public Address getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public MessageMediaParticipant messages(List<MessageDetails> messages) {
        this.messages = messages;
        return this;
    }

    @ApiModelProperty(example="null", value="Message instance details on the communication.")
    @JsonProperty(value="messages")
    public List<MessageDetails> getMessages() {
        return this.messages;
    }

    public void setMessages(List<MessageDetails> messages) {
        this.messages = messages;
    }

    public MessageMediaParticipant type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the type of message platform from which the message originated.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MessageMediaParticipant recipientCountry(String recipientCountry) {
        this.recipientCountry = recipientCountry;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the country where the recipient is associated in ISO 3166-1 alpha-2 format.")
    @JsonProperty(value="recipientCountry")
    public String getRecipientCountry() {
        return this.recipientCountry;
    }

    public void setRecipientCountry(String recipientCountry) {
        this.recipientCountry = recipientCountry;
    }

    public MessageMediaParticipant recipientType(String recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the recipient. Eg: Provisioned phoneNumber is the recipient for sms message type.")
    @JsonProperty(value="recipientType")
    public String getRecipientType() {
        return this.recipientType;
    }

    public void setRecipientType(String recipientType) {
        this.recipientType = recipientType;
    }

    public MessageMediaParticipant authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, the participant member is authenticated.")
    @JsonProperty(value="authenticated")
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public MessageMediaParticipant monitoredParticipantId(String monitoredParticipantId) {
        this.monitoredParticipantId = monitoredParticipantId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the participant being monitored when performing a message monitor.")
    @JsonProperty(value="monitoredParticipantId")
    public String getMonitoredParticipantId() {
        return this.monitoredParticipantId;
    }

    public void setMonitoredParticipantId(String monitoredParticipantId) {
        this.monitoredParticipantId = monitoredParticipantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageMediaParticipant messageMediaParticipant = (MessageMediaParticipant)o;
        return Objects.equals(this.id, messageMediaParticipant.id) && Objects.equals(this.name, messageMediaParticipant.name) && Objects.equals(this.address, messageMediaParticipant.address) && Objects.equals(this.startTime, messageMediaParticipant.startTime) && Objects.equals(this.connectedTime, messageMediaParticipant.connectedTime) && Objects.equals(this.endTime, messageMediaParticipant.endTime) && Objects.equals(this.startHoldTime, messageMediaParticipant.startHoldTime) && Objects.equals(this.purpose, messageMediaParticipant.purpose) && Objects.equals((Object)this.state, (Object)messageMediaParticipant.state) && Objects.equals((Object)this.direction, (Object)messageMediaParticipant.direction) && Objects.equals((Object)this.disconnectType, (Object)messageMediaParticipant.disconnectType) && Objects.equals(this.held, messageMediaParticipant.held) && Objects.equals(this.wrapupRequired, messageMediaParticipant.wrapupRequired) && Objects.equals(this.wrapupPrompt, messageMediaParticipant.wrapupPrompt) && Objects.equals(this.mediaRoles, messageMediaParticipant.mediaRoles) && Objects.equals(this.user, messageMediaParticipant.user) && Objects.equals(this.queue, messageMediaParticipant.queue) && Objects.equals(this.team, messageMediaParticipant.team) && Objects.equals(this.attributes, messageMediaParticipant.attributes) && Objects.equals(this.errorInfo, messageMediaParticipant.errorInfo) && Objects.equals(this.script, messageMediaParticipant.script) && Objects.equals(this.wrapupTimeoutMs, messageMediaParticipant.wrapupTimeoutMs) && Objects.equals(this.wrapupSkipped, messageMediaParticipant.wrapupSkipped) && Objects.equals(this.alertingTimeoutMs, messageMediaParticipant.alertingTimeoutMs) && Objects.equals(this.provider, messageMediaParticipant.provider) && Objects.equals(this.externalContact, messageMediaParticipant.externalContact) && Objects.equals(this.externalOrganization, messageMediaParticipant.externalOrganization) && Objects.equals(this.wrapup, messageMediaParticipant.wrapup) && Objects.equals(this.peer, messageMediaParticipant.peer) && Objects.equals((Object)this.flaggedReason, (Object)messageMediaParticipant.flaggedReason) && Objects.equals(this.journeyContext, messageMediaParticipant.journeyContext) && Objects.equals(this.conversationRoutingData, messageMediaParticipant.conversationRoutingData) && Objects.equals(this.startAcwTime, messageMediaParticipant.startAcwTime) && Objects.equals(this.endAcwTime, messageMediaParticipant.endAcwTime) && Objects.equals(this.toAddress, messageMediaParticipant.toAddress) && Objects.equals(this.fromAddress, messageMediaParticipant.fromAddress) && Objects.equals(this.messages, messageMediaParticipant.messages) && Objects.equals((Object)this.type, (Object)messageMediaParticipant.type) && Objects.equals(this.recipientCountry, messageMediaParticipant.recipientCountry) && Objects.equals(this.recipientType, messageMediaParticipant.recipientType) && Objects.equals(this.authenticated, messageMediaParticipant.authenticated) && Objects.equals(this.monitoredParticipantId, messageMediaParticipant.monitoredParticipantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.address, this.startTime, this.connectedTime, this.endTime, this.startHoldTime, this.purpose, this.state, this.direction, this.disconnectType, this.held, this.wrapupRequired, this.wrapupPrompt, this.mediaRoles, this.user, this.queue, this.team, this.attributes, this.errorInfo, this.script, this.wrapupTimeoutMs, this.wrapupSkipped, this.alertingTimeoutMs, this.provider, this.externalContact, this.externalOrganization, this.wrapup, this.peer, this.flaggedReason, this.journeyContext, this.conversationRoutingData, this.startAcwTime, this.endAcwTime, this.toAddress, this.fromAddress, this.messages, this.type, this.recipientCountry, this.recipientType, this.authenticated, this.monitoredParticipantId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageMediaParticipant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    wrapupRequired: ").append(this.toIndentedString(this.wrapupRequired)).append("\n");
        sb.append("    wrapupPrompt: ").append(this.toIndentedString(this.wrapupPrompt)).append("\n");
        sb.append("    mediaRoles: ").append(this.toIndentedString(this.mediaRoles)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    wrapupTimeoutMs: ").append(this.toIndentedString(this.wrapupTimeoutMs)).append("\n");
        sb.append("    wrapupSkipped: ").append(this.toIndentedString(this.wrapupSkipped)).append("\n");
        sb.append("    alertingTimeoutMs: ").append(this.toIndentedString(this.alertingTimeoutMs)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    peer: ").append(this.toIndentedString(this.peer)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    journeyContext: ").append(this.toIndentedString(this.journeyContext)).append("\n");
        sb.append("    conversationRoutingData: ").append(this.toIndentedString(this.conversationRoutingData)).append("\n");
        sb.append("    startAcwTime: ").append(this.toIndentedString(this.startAcwTime)).append("\n");
        sb.append("    endAcwTime: ").append(this.toIndentedString(this.endAcwTime)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    recipientCountry: ").append(this.toIndentedString(this.recipientCountry)).append("\n");
        sb.append("    recipientType: ").append(this.toIndentedString(this.recipientType)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("    monitoredParticipantId: ").append(this.toIndentedString(this.monitoredParticipantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        ENDPOINT_DONOTDISTURB("endpoint.donotdisturb"),
        CLIENT("client"),
        SYSTEM("system"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_DONOTDISTURB("transfer.donotdisturb"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FlaggedReasonEnumDeserializer.class)
    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("unknown"),
        SMS("sms"),
        TWITTER("twitter"),
        FACEBOOK("facebook"),
        LINE("line"),
        WHATSAPP("whatsapp"),
        TELEGRAM("telegram"),
        KAKAO("kakao"),
        WEBMESSAGING("webmessaging"),
        OPEN("open"),
        INSTAGRAM("instagram");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FlaggedReasonEnumDeserializer
    extends StdDeserializer<FlaggedReasonEnum> {
        public FlaggedReasonEnumDeserializer() {
            super(FlaggedReasonEnumDeserializer.class);
        }

        public FlaggedReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlaggedReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

