/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.KnowledgeConversationContext;
import com.mypurecloud.sdk.v2.model.KnowledgeSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeDocumentView
implements Serializable {
    private String documentVariationId = null;
    private String documentVersionId = null;
    private String searchId = null;
    private QueryTypeEnum queryType = null;
    private KnowledgeSearchClientApplication application = null;
    private String sessionId = null;
    private KnowledgeConversationContext conversationContext = null;

    public KnowledgeDocumentView documentVariationId(String documentVariationId) {
        this.documentVariationId = documentVariationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The variation of the viewed document.")
    @JsonProperty(value="documentVariationId")
    public String getDocumentVariationId() {
        return this.documentVariationId;
    }

    public void setDocumentVariationId(String documentVariationId) {
        this.documentVariationId = documentVariationId;
    }

    public KnowledgeDocumentView documentVersionId(String documentVersionId) {
        this.documentVersionId = documentVersionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the viewed document.")
    @JsonProperty(value="documentVersionId")
    public String getDocumentVersionId() {
        return this.documentVersionId;
    }

    public void setDocumentVersionId(String documentVersionId) {
        this.documentVersionId = documentVersionId;
    }

    public KnowledgeDocumentView searchId(String searchId) {
        this.searchId = searchId;
        return this;
    }

    @ApiModelProperty(example="null", value="The search that surfaced the viewed document.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    public void setSearchId(String searchId) {
        this.searchId = searchId;
    }

    public KnowledgeDocumentView queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that surfaced the document.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeDocumentView application(KnowledgeSearchClientApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The client application from which the document was viewed.")
    @JsonProperty(value="application")
    public KnowledgeSearchClientApplication getApplication() {
        return this.application;
    }

    public void setApplication(KnowledgeSearchClientApplication application) {
        this.application = application;
    }

    public KnowledgeDocumentView sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of the knowledge session in which the document was viewed.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public KnowledgeDocumentView conversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Conversation context information if the document was viewed in the context of a conversation.")
    @JsonProperty(value="conversationContext")
    public KnowledgeConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentView knowledgeDocumentView = (KnowledgeDocumentView)o;
        return Objects.equals(this.documentVariationId, knowledgeDocumentView.documentVariationId) && Objects.equals(this.documentVersionId, knowledgeDocumentView.documentVersionId) && Objects.equals(this.searchId, knowledgeDocumentView.searchId) && Objects.equals((Object)this.queryType, (Object)knowledgeDocumentView.queryType) && Objects.equals(this.application, knowledgeDocumentView.application) && Objects.equals(this.sessionId, knowledgeDocumentView.sessionId) && Objects.equals(this.conversationContext, knowledgeDocumentView.conversationContext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentVariationId, this.documentVersionId, this.searchId, this.queryType, this.application, this.sessionId, this.conversationContext});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentView {\n");
        sb.append("    documentVariationId: ").append(this.toIndentedString(this.documentVariationId)).append("\n");
        sb.append("    documentVersionId: ").append(this.toIndentedString(this.documentVersionId)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    conversationContext: ").append(this.toIndentedString(this.conversationContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        AUTOSEARCH("AutoSearch"),
        CATEGORY("Category"),
        MANUALSEARCH("ManualSearch"),
        RECOMMENDATION("Recommendation"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

