/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetUserProfileRequest {
    private String userId;
    private List<String> expand;
    private String integrationPresenceSource;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetUserProfileRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetUserProfileRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public String getIntegrationPresenceSource() {
        return this.integrationPresenceSource;
    }

    public void setIntegrationPresenceSource(String integrationPresenceSource) {
        this.integrationPresenceSource = integrationPresenceSource;
    }

    public GetUserProfileRequest withIntegrationPresenceSource(String integrationPresenceSource) {
        this.setIntegrationPresenceSource(integrationPresenceSource);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUserProfileRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserProfileRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/{userId}/profile").withPathParameter("userId", this.userId).withQueryParameters("expand", "multi", this.expand).withQueryParameters("integrationPresenceSource", "", this.integrationPresenceSource).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId) {
        return new Builder().withRequiredParams(userId);
    }

    public static class Builder {
        private final GetUserProfileRequest request = new GetUserProfileRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withIntegrationPresenceSource(String integrationPresenceSource) {
            this.request.setIntegrationPresenceSource(integrationPresenceSource);
            return this;
        }

        public Builder withIntegrationPresenceSource(integrationPresenceSourceValues integrationPresenceSource) {
            this.request.setIntegrationPresenceSource(integrationPresenceSource.toString());
            return this;
        }

        public Builder withRequiredParams(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public GetUserProfileRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserProfileRequest.");
            }
            return this.request;
        }
    }

    public static enum integrationPresenceSourceValues {
        MICROSOFTTEAMS("MicrosoftTeams"),
        ZOOMPHONE("ZoomPhone"),
        EIGHTBYEIGHT("EightByEight");

        private String value;

        private integrationPresenceSourceValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static integrationPresenceSourceValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (integrationPresenceSourceValues value : integrationPresenceSourceValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return integrationPresenceSourceValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum expandValues {
        ROUTINGSTATUS("routingStatus"),
        PRESENCE("presence"),
        INTEGRATIONPRESENCE("integrationPresence"),
        CONVERSATIONSUMMARY("conversationSummary"),
        OUTOFOFFICE("outOfOffice"),
        GEOLOCATION("geolocation"),
        STATION("station"),
        AUTHORIZATION("authorization"),
        LASTTOKENISSUED("lasttokenissued"),
        DATELASTLOGIN("dateLastLogin"),
        AUTHORIZATION_UNUSEDROLES("authorization.unusedRoles"),
        TEAM("team");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

