/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.WorkitemScoredAgentRequest;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkitemUpdate
implements Serializable {
    private String name = null;
    private Integer priority = null;
    private Date dateDue = null;
    private Date dateExpires = null;
    private Integer durationSeconds = null;
    private Integer ttl = null;
    private String statusId = null;
    private String workbinId = null;
    private Boolean autoStatusTransition = null;
    private String description = null;
    private Date dateClosed = null;
    private AssignmentStateEnum assignmentState = null;
    private AssignmentOperationEnum assignmentOperation = null;
    private Map<String, Object> customFields = null;
    private String queueId = null;
    private String assigneeId = null;
    private List<WorkitemScoredAgentRequest> scoredAgents = new ArrayList<WorkitemScoredAgentRequest>();
    private String externalContactId = null;
    private String externalTag = null;
    private List<String> skillIds = new ArrayList<String>();
    private String languageId = null;
    private List<String> preferredAgentIds = new ArrayList<String>();

    public WorkitemUpdate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the Workitem. Valid length between 3 and 256 characters.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkitemUpdate priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the Workitem. The valid range is between -25,000,000 and 25,000,000.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public WorkitemUpdate dateDue(Date dateDue) {
        this.dateDue = dateDue;
        return this;
    }

    @ApiModelProperty(example="null", value="The due date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateDue")
    public Date getDateDue() {
        return this.dateDue;
    }

    public void setDateDue(Date dateDue) {
        this.dateDue = dateDue;
    }

    public WorkitemUpdate dateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiry date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpires")
    public Date getDateExpires() {
        return this.dateExpires;
    }

    public void setDateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
    }

    public WorkitemUpdate durationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The estimated duration in seconds to complete the Workitem. Maximum of 365 days.")
    @JsonProperty(value="durationSeconds")
    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public WorkitemUpdate ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @ApiModelProperty(example="null", value="The epoch timestamp in seconds specifying the time to live for the Workitem. Can not be greater than 365 days from the current time.")
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public WorkitemUpdate statusId(String statusId) {
        this.statusId = statusId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Status of the Workitem.")
    @JsonProperty(value="statusId")
    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public WorkitemUpdate workbinId(String workbinId) {
        this.workbinId = workbinId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of Workbin that contains the Workitem.")
    @JsonProperty(value="workbinId")
    public String getWorkbinId() {
        return this.workbinId;
    }

    public void setWorkbinId(String workbinId) {
        this.workbinId = workbinId;
    }

    public WorkitemUpdate autoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
        return this;
    }

    @ApiModelProperty(example="null", value="Set it to false to disable auto status transition. By default, it is enabled.")
    @JsonProperty(value="autoStatusTransition")
    public Boolean getAutoStatusTransition() {
        return this.autoStatusTransition;
    }

    public void setAutoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
    }

    public WorkitemUpdate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Workitem. Maximum length of 4096 characters.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkitemUpdate dateClosed(Date dateClosed) {
        this.dateClosed = dateClosed;
        return this;
    }

    @ApiModelProperty(example="null", value="The closed date of the Workitem. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateClosed")
    public Date getDateClosed() {
        return this.dateClosed;
    }

    public void setDateClosed(Date dateClosed) {
        this.dateClosed = dateClosed;
    }

    public WorkitemUpdate assignmentState(AssignmentStateEnum assignmentState) {
        this.assignmentState = assignmentState;
        return this;
    }

    @ApiModelProperty(example="null", value="The assignment state of the Workitem.")
    @JsonProperty(value="assignmentState")
    public AssignmentStateEnum getAssignmentState() {
        return this.assignmentState;
    }

    public void setAssignmentState(AssignmentStateEnum assignmentState) {
        this.assignmentState = assignmentState;
    }

    public WorkitemUpdate assignmentOperation(AssignmentOperationEnum assignmentOperation) {
        this.assignmentOperation = assignmentOperation;
        return this;
    }

    @ApiModelProperty(example="null", value="Set this value to AgentAssignmentAlerting and supply an 'assigneeId' to assign the workitem to an agent and alert the agent of the assignment. Set this value to QueueAssignmentAlerting and supply a 'queueId' to route the workitem to an agent who is a member of the queue and alert the agent.")
    @JsonProperty(value="assignmentOperation")
    public AssignmentOperationEnum getAssignmentOperation() {
        return this.assignmentOperation;
    }

    public void setAssignmentOperation(AssignmentOperationEnum assignmentOperation) {
        this.assignmentOperation = assignmentOperation;
    }

    public WorkitemUpdate customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom fields defined in the schema referenced by the Workitem. If set to {}, the existing keys and values will be removed.")
    @JsonProperty(value="customFields")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public WorkitemUpdate queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Workitems queue. Must be a valid UUID.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public WorkitemUpdate assigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the assignee of the Workitem. If supplied it must be a valid UUID.")
    @JsonProperty(value="assigneeId")
    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    public WorkitemUpdate scoredAgents(List<WorkitemScoredAgentRequest> scoredAgents) {
        this.scoredAgents = scoredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of scored agents for the Workitem. A workitem can have a maximum of 20 scored agents.")
    @JsonProperty(value="scoredAgents")
    public List<WorkitemScoredAgentRequest> getScoredAgents() {
        return this.scoredAgents;
    }

    public void setScoredAgents(List<WorkitemScoredAgentRequest> scoredAgents) {
        this.scoredAgents = scoredAgents;
    }

    public WorkitemUpdate externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the external contact of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public WorkitemUpdate externalTag(String externalTag) {
        this.externalTag = externalTag;
        return this;
    }

    @ApiModelProperty(example="null", value="The external tag of the Workitem.")
    @JsonProperty(value="externalTag")
    public String getExternalTag() {
        return this.externalTag;
    }

    public void setExternalTag(String externalTag) {
        this.externalTag = externalTag;
    }

    public WorkitemUpdate skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The skill IDs of the Workitem. Must be valid UUIDs.")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public WorkitemUpdate languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of language of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public WorkitemUpdate preferredAgentIds(List<String> preferredAgentIds) {
        this.preferredAgentIds = preferredAgentIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The preferred agent IDs of the Workitem. Must be valid UUIDs.")
    @JsonProperty(value="preferredAgentIds")
    public List<String> getPreferredAgentIds() {
        return this.preferredAgentIds;
    }

    public void setPreferredAgentIds(List<String> preferredAgentIds) {
        this.preferredAgentIds = preferredAgentIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemUpdate workitemUpdate = (WorkitemUpdate)o;
        return Objects.equals(this.name, workitemUpdate.name) && Objects.equals(this.priority, workitemUpdate.priority) && Objects.equals(this.dateDue, workitemUpdate.dateDue) && Objects.equals(this.dateExpires, workitemUpdate.dateExpires) && Objects.equals(this.durationSeconds, workitemUpdate.durationSeconds) && Objects.equals(this.ttl, workitemUpdate.ttl) && Objects.equals(this.statusId, workitemUpdate.statusId) && Objects.equals(this.workbinId, workitemUpdate.workbinId) && Objects.equals(this.autoStatusTransition, workitemUpdate.autoStatusTransition) && Objects.equals(this.description, workitemUpdate.description) && Objects.equals(this.dateClosed, workitemUpdate.dateClosed) && Objects.equals((Object)this.assignmentState, (Object)workitemUpdate.assignmentState) && Objects.equals((Object)this.assignmentOperation, (Object)workitemUpdate.assignmentOperation) && Objects.equals(this.customFields, workitemUpdate.customFields) && Objects.equals(this.queueId, workitemUpdate.queueId) && Objects.equals(this.assigneeId, workitemUpdate.assigneeId) && Objects.equals(this.scoredAgents, workitemUpdate.scoredAgents) && Objects.equals(this.externalContactId, workitemUpdate.externalContactId) && Objects.equals(this.externalTag, workitemUpdate.externalTag) && Objects.equals(this.skillIds, workitemUpdate.skillIds) && Objects.equals(this.languageId, workitemUpdate.languageId) && Objects.equals(this.preferredAgentIds, workitemUpdate.preferredAgentIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.priority, this.dateDue, this.dateExpires, this.durationSeconds, this.ttl, this.statusId, this.workbinId, this.autoStatusTransition, this.description, this.dateClosed, this.assignmentState, this.assignmentOperation, this.customFields, this.queueId, this.assigneeId, this.scoredAgents, this.externalContactId, this.externalTag, this.skillIds, this.languageId, this.preferredAgentIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    dateDue: ").append(this.toIndentedString(this.dateDue)).append("\n");
        sb.append("    dateExpires: ").append(this.toIndentedString(this.dateExpires)).append("\n");
        sb.append("    durationSeconds: ").append(this.toIndentedString(this.durationSeconds)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    statusId: ").append(this.toIndentedString(this.statusId)).append("\n");
        sb.append("    workbinId: ").append(this.toIndentedString(this.workbinId)).append("\n");
        sb.append("    autoStatusTransition: ").append(this.toIndentedString(this.autoStatusTransition)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateClosed: ").append(this.toIndentedString(this.dateClosed)).append("\n");
        sb.append("    assignmentState: ").append(this.toIndentedString((Object)this.assignmentState)).append("\n");
        sb.append("    assignmentOperation: ").append(this.toIndentedString((Object)this.assignmentOperation)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    assigneeId: ").append(this.toIndentedString(this.assigneeId)).append("\n");
        sb.append("    scoredAgents: ").append(this.toIndentedString(this.scoredAgents)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    externalTag: ").append(this.toIndentedString(this.externalTag)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    preferredAgentIds: ").append(this.toIndentedString(this.preferredAgentIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AssignmentStateEnumDeserializer.class)
    public static enum AssignmentStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ACDSTARTED("AcdStarted"),
        ALERTING("Alerting"),
        ALERTTIMEOUT("AlertTimeout"),
        ACDCANCELLED("AcdCancelled"),
        TERMINATED("Terminated"),
        IDLE("Idle"),
        DECLINED("Declined"),
        CONNECTED("Connected"),
        DISCONNECTED("Disconnected"),
        PARKED("Parked"),
        HELD("Held"),
        ACDEXPIRED("AcdExpired");

        private String value;

        private AssignmentStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AssignmentStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AssignmentStateEnum value : AssignmentStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AssignmentStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AssignmentOperationEnumDeserializer.class)
    public static enum AssignmentOperationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENTASSIGNMENTALERTING("AgentAssignmentAlerting"),
        QUEUEASSIGNMENTALERTING("QueueAssignmentAlerting");

        private String value;

        private AssignmentOperationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AssignmentOperationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AssignmentOperationEnum value : AssignmentOperationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AssignmentOperationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AssignmentOperationEnumDeserializer
    extends StdDeserializer<AssignmentOperationEnum> {
        public AssignmentOperationEnumDeserializer() {
            super(AssignmentOperationEnumDeserializer.class);
        }

        public AssignmentOperationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AssignmentOperationEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AssignmentStateEnumDeserializer
    extends StdDeserializer<AssignmentStateEnum> {
        public AssignmentStateEnumDeserializer() {
            super(AssignmentStateEnumDeserializer.class);
        }

        public AssignmentStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AssignmentStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

