/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContentCard;
import com.mypurecloud.sdk.v2.model.ContentCarousel;
import com.mypurecloud.sdk.v2.model.WebMessagingAttachment;
import com.mypurecloud.sdk.v2.model.WebMessagingButtonResponse;
import com.mypurecloud.sdk.v2.model.WebMessagingGeneric;
import com.mypurecloud.sdk.v2.model.WebMessagingQuickReply;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Message content element.")
public class WebMessagingContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private WebMessagingAttachment attachment = null;
    private WebMessagingQuickReply quickReply = null;
    private WebMessagingButtonResponse buttonResponse = null;
    private WebMessagingGeneric generic = null;
    private ContentCard card = null;
    private ContentCarousel carousel = null;

    @ApiModelProperty(example="null", value="Type of this content element. If contentType = \"Attachment\" only one item is allowed.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @ApiModelProperty(example="null", value="Attachment content.")
    @JsonProperty(value="attachment")
    public WebMessagingAttachment getAttachment() {
        return this.attachment;
    }

    public WebMessagingContent quickReply(WebMessagingQuickReply quickReply) {
        this.quickReply = quickReply;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply content.")
    @JsonProperty(value="quickReply")
    public WebMessagingQuickReply getQuickReply() {
        return this.quickReply;
    }

    public void setQuickReply(WebMessagingQuickReply quickReply) {
        this.quickReply = quickReply;
    }

    public WebMessagingContent buttonResponse(WebMessagingButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response content.")
    @JsonProperty(value="buttonResponse")
    public WebMessagingButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(WebMessagingButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public WebMessagingContent generic(WebMessagingGeneric generic) {
        this.generic = generic;
        return this;
    }

    @ApiModelProperty(example="null", value="Generic content (Deprecated).")
    @JsonProperty(value="generic")
    public WebMessagingGeneric getGeneric() {
        return this.generic;
    }

    public void setGeneric(WebMessagingGeneric generic) {
        this.generic = generic;
    }

    public WebMessagingContent card(ContentCard card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(example="null", value="Card content")
    @JsonProperty(value="card")
    public ContentCard getCard() {
        return this.card;
    }

    public void setCard(ContentCard card) {
        this.card = card;
    }

    public WebMessagingContent carousel(ContentCarousel carousel) {
        this.carousel = carousel;
        return this;
    }

    @ApiModelProperty(example="null", value="Carousel content")
    @JsonProperty(value="carousel")
    public ContentCarousel getCarousel() {
        return this.carousel;
    }

    public void setCarousel(ContentCarousel carousel) {
        this.carousel = carousel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingContent webMessagingContent = (WebMessagingContent)o;
        return Objects.equals((Object)this.contentType, (Object)webMessagingContent.contentType) && Objects.equals(this.attachment, webMessagingContent.attachment) && Objects.equals(this.quickReply, webMessagingContent.quickReply) && Objects.equals(this.buttonResponse, webMessagingContent.buttonResponse) && Objects.equals(this.generic, webMessagingContent.generic) && Objects.equals(this.card, webMessagingContent.card) && Objects.equals(this.carousel, webMessagingContent.carousel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.attachment, this.quickReply, this.buttonResponse, this.generic, this.card, this.carousel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    quickReply: ").append(this.toIndentedString(this.quickReply)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("    generic: ").append(this.toIndentedString(this.generic)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    carousel: ").append(this.toIndentedString(this.carousel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTACHMENT("Attachment"),
        QUICKREPLY("QuickReply"),
        BUTTONRESPONSE("ButtonResponse"),
        GENERICTEMPLATE("GenericTemplate"),
        CARD("Card"),
        CAROUSEL("Carousel");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

