/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Calibration;
import java.util.HashMap;
import java.util.Map;

public class PutQualityCalibrationRequest {
    private String calibrationId;
    private Calibration body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCalibrationId() {
        return this.calibrationId;
    }

    public void setCalibrationId(String calibrationId) {
        this.calibrationId = calibrationId;
    }

    public PutQualityCalibrationRequest withCalibrationId(String calibrationId) {
        this.setCalibrationId(calibrationId);
        return this;
    }

    public Calibration getBody() {
        return this.body;
    }

    public void setBody(Calibration body) {
        this.body = body;
    }

    public PutQualityCalibrationRequest withBody(Calibration body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutQualityCalibrationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Calibration> withHttpInfo() {
        if (this.calibrationId == null) {
            throw new IllegalStateException("Missing the required parameter 'calibrationId' when building request for PutQualityCalibrationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityCalibrationRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/quality/calibrations/{calibrationId}").withPathParameter("calibrationId", this.calibrationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String calibrationId, Calibration body) {
        return new Builder().withRequiredParams(calibrationId, body);
    }

    public static class Builder {
        private final PutQualityCalibrationRequest request = new PutQualityCalibrationRequest();

        private Builder() {
        }

        public Builder withCalibrationId(String calibrationId) {
            this.request.setCalibrationId(calibrationId);
            return this;
        }

        public Builder withBody(Calibration body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String calibrationId, Calibration body) {
            this.request.setCalibrationId(calibrationId);
            this.request.setBody(body);
            return this;
        }

        public PutQualityCalibrationRequest build() {
            if (this.request.calibrationId == null) {
                throw new IllegalStateException("Missing the required parameter 'calibrationId' when building request for PutQualityCalibrationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityCalibrationRequest.");
            }
            return this.request;
        }
    }
}

