/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Defines a SCIM phone number.")
public class ScimPhoneNumber
implements Serializable {
    private String value = null;
    private TypeEnum type = null;
    private Boolean primary = null;

    public ScimPhoneNumber value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number in E.164 or tel URI format, for example, tel:+nnnnnnnn; ext=xxxxx.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ScimPhoneNumber type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of phone number.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ScimPhoneNumber primary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the phone number is the primary phone number.")
    @JsonProperty(value="primary")
    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimPhoneNumber scimPhoneNumber = (ScimPhoneNumber)o;
        return Objects.equals(this.value, scimPhoneNumber.value) && Objects.equals((Object)this.type, (Object)scimPhoneNumber.type) && Objects.equals(this.primary, scimPhoneNumber.primary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type, this.primary});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimPhoneNumber {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WORK("work"),
        WORK2("work2"),
        WORK3("work3"),
        WORK4("work4"),
        HOME("home"),
        MOBILE("mobile"),
        OTHER("other"),
        MICROSOFTTEAMS("microsoftteams"),
        ZOOMPHONE("zoomphone"),
        EIGHTBYEIGHT("eightbyeight");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

