/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MinerExecuteRequest
implements Serializable {
    private LocalDate dateStart = null;
    private LocalDate dateEnd = null;
    private String uploadKey = null;
    private MediaTypeEnum mediaType = null;
    private ParticipantTypeEnum participantType = null;
    private List<String> queueIds = new ArrayList<String>();

    public MinerExecuteRequest dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="Wed Apr 01 00:00:00 UTC 2020", value="Start date for the date range to mine. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStart")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public MinerExecuteRequest dateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="Wed Apr 01 00:00:00 UTC 2020", value="End date for the date range to mine. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEnd")
    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public MinerExecuteRequest uploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
        return this;
    }

    @ApiModelProperty(example="intent-miner/raw-utterances/imports/org_id/request_id.mine_id.json", value="Location of input conversations.")
    @JsonProperty(value="uploadKey")
    public String getUploadKey() {
        return this.uploadKey;
    }

    public void setUploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
    }

    public MinerExecuteRequest mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media type for filtering conversations.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public MinerExecuteRequest participantType(ParticipantTypeEnum participantType) {
        this.participantType = participantType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the participant, either agent, customer or both.")
    @JsonProperty(value="participantType")
    public ParticipantTypeEnum getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(ParticipantTypeEnum participantType) {
        this.participantType = participantType;
    }

    public MinerExecuteRequest queueIds(List<String> queueIds) {
        this.queueIds = queueIds;
        return this;
    }

    @ApiModelProperty(example="[ &quot;7fe8a4ce-7435-4c78-a83f-47c3943e53eb&quot;, &quot;18c744bf-34d5-452a-b6d6-9af95628aa50&quot;]", value="List of queue IDs for filtering conversations.")
    @JsonProperty(value="queueIds")
    public List<String> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(List<String> queueIds) {
        this.queueIds = queueIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinerExecuteRequest minerExecuteRequest = (MinerExecuteRequest)o;
        return Objects.equals(this.dateStart, minerExecuteRequest.dateStart) && Objects.equals(this.dateEnd, minerExecuteRequest.dateEnd) && Objects.equals(this.uploadKey, minerExecuteRequest.uploadKey) && Objects.equals((Object)this.mediaType, (Object)minerExecuteRequest.mediaType) && Objects.equals((Object)this.participantType, (Object)minerExecuteRequest.participantType) && Objects.equals(this.queueIds, minerExecuteRequest.queueIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateStart, this.dateEnd, this.uploadKey, this.mediaType, this.participantType, this.queueIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MinerExecuteRequest {\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    uploadKey: ").append(this.toIndentedString(this.uploadKey)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    participantType: ").append(this.toIndentedString((Object)this.participantType)).append("\n");
        sb.append("    queueIds: ").append(this.toIndentedString(this.queueIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CHAT("Chat"),
        CALL("Call"),
        MESSAGE("Message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ParticipantTypeEnumDeserializer.class)
    public static enum ParticipantTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CUSTOMER("Customer"),
        AGENT("Agent"),
        BOTH("Both");

        private String value;

        private ParticipantTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ParticipantTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ParticipantTypeEnum value : ParticipantTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ParticipantTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ParticipantTypeEnumDeserializer
    extends StdDeserializer<ParticipantTypeEnum> {
        public ParticipantTypeEnumDeserializer() {
            super(ParticipantTypeEnumDeserializer.class);
        }

        public ParticipantTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ParticipantTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

