/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.TargetPerformanceProfile;
import java.util.HashMap;
import java.util.Map;

public class PostGamificationProfileMetricLinkRequest {
    private String sourceProfileId;
    private String sourceMetricId;
    private TargetPerformanceProfile body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSourceProfileId() {
        return this.sourceProfileId;
    }

    public void setSourceProfileId(String sourceProfileId) {
        this.sourceProfileId = sourceProfileId;
    }

    public PostGamificationProfileMetricLinkRequest withSourceProfileId(String sourceProfileId) {
        this.setSourceProfileId(sourceProfileId);
        return this;
    }

    public String getSourceMetricId() {
        return this.sourceMetricId;
    }

    public void setSourceMetricId(String sourceMetricId) {
        this.sourceMetricId = sourceMetricId;
    }

    public PostGamificationProfileMetricLinkRequest withSourceMetricId(String sourceMetricId) {
        this.setSourceMetricId(sourceMetricId);
        return this;
    }

    public TargetPerformanceProfile getBody() {
        return this.body;
    }

    public void setBody(TargetPerformanceProfile body) {
        this.body = body;
    }

    public PostGamificationProfileMetricLinkRequest withBody(TargetPerformanceProfile body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostGamificationProfileMetricLinkRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<TargetPerformanceProfile> withHttpInfo() {
        if (this.sourceProfileId == null) {
            throw new IllegalStateException("Missing the required parameter 'sourceProfileId' when building request for PostGamificationProfileMetricLinkRequest.");
        }
        if (this.sourceMetricId == null) {
            throw new IllegalStateException("Missing the required parameter 'sourceMetricId' when building request for PostGamificationProfileMetricLinkRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostGamificationProfileMetricLinkRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/gamification/profiles/{sourceProfileId}/metrics/{sourceMetricId}/link").withPathParameter("sourceProfileId", this.sourceProfileId).withPathParameter("sourceMetricId", this.sourceMetricId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sourceProfileId, String sourceMetricId, TargetPerformanceProfile body) {
        return new Builder().withRequiredParams(sourceProfileId, sourceMetricId, body);
    }

    public static class Builder {
        private final PostGamificationProfileMetricLinkRequest request = new PostGamificationProfileMetricLinkRequest();

        private Builder() {
        }

        public Builder withSourceProfileId(String sourceProfileId) {
            this.request.setSourceProfileId(sourceProfileId);
            return this;
        }

        public Builder withSourceMetricId(String sourceMetricId) {
            this.request.setSourceMetricId(sourceMetricId);
            return this;
        }

        public Builder withBody(TargetPerformanceProfile body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String sourceProfileId, String sourceMetricId, TargetPerformanceProfile body) {
            this.request.setSourceProfileId(sourceProfileId);
            this.request.setSourceMetricId(sourceMetricId);
            this.request.setBody(body);
            return this;
        }

        public PostGamificationProfileMetricLinkRequest build() {
            if (this.request.sourceProfileId == null) {
                throw new IllegalStateException("Missing the required parameter 'sourceProfileId' when building request for PostGamificationProfileMetricLinkRequest.");
            }
            if (this.request.sourceMetricId == null) {
                throw new IllegalStateException("Missing the required parameter 'sourceMetricId' when building request for PostGamificationProfileMetricLinkRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostGamificationProfileMetricLinkRequest.");
            }
            return this.request;
        }
    }
}

