/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AddConversationRequest;
import java.util.HashMap;
import java.util.Map;

public class PostCoachingAppointmentConversationsRequest {
    private String appointmentId;
    private AddConversationRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public PostCoachingAppointmentConversationsRequest withAppointmentId(String appointmentId) {
        this.setAppointmentId(appointmentId);
        return this;
    }

    public AddConversationRequest getBody() {
        return this.body;
    }

    public void setBody(AddConversationRequest body) {
        this.body = body;
    }

    public PostCoachingAppointmentConversationsRequest withBody(AddConversationRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostCoachingAppointmentConversationsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AddConversationRequest> withHttpInfo() {
        if (this.appointmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PostCoachingAppointmentConversationsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostCoachingAppointmentConversationsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/coaching/appointments/{appointmentId}/conversations").withPathParameter("appointmentId", this.appointmentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String appointmentId, AddConversationRequest body) {
        return new Builder().withRequiredParams(appointmentId, body);
    }

    public static class Builder {
        private final PostCoachingAppointmentConversationsRequest request = new PostCoachingAppointmentConversationsRequest();

        private Builder() {
        }

        public Builder withAppointmentId(String appointmentId) {
            this.request.setAppointmentId(appointmentId);
            return this;
        }

        public Builder withBody(AddConversationRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String appointmentId, AddConversationRequest body) {
            this.request.setAppointmentId(appointmentId);
            this.request.setBody(body);
            return this;
        }

        public PostCoachingAppointmentConversationsRequest build() {
            if (this.request.appointmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PostCoachingAppointmentConversationsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostCoachingAppointmentConversationsRequest.");
            }
            return this.request;
        }
    }
}

