/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetLearningModuleVersionRequest {
    private String moduleId;
    private String versionId;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public GetLearningModuleVersionRequest withModuleId(String moduleId) {
        this.setModuleId(moduleId);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public GetLearningModuleVersionRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetLearningModuleVersionRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetLearningModuleVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.moduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for GetLearningModuleVersionRequest.");
        }
        if (this.versionId == null) {
            throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetLearningModuleVersionRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/learning/modules/{moduleId}/versions/{versionId}").withPathParameter("moduleId", this.moduleId).withPathParameter("versionId", this.versionId).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String moduleId, String versionId) {
        return new Builder().withRequiredParams(moduleId, versionId);
    }

    public static class Builder {
        private final GetLearningModuleVersionRequest request = new GetLearningModuleVersionRequest();

        private Builder() {
        }

        public Builder withModuleId(String moduleId) {
            this.request.setModuleId(moduleId);
            return this;
        }

        public Builder withVersionId(String versionId) {
            this.request.setVersionId(versionId);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String moduleId, String versionId) {
            this.request.setModuleId(moduleId);
            this.request.setVersionId(versionId);
            return this;
        }

        public GetLearningModuleVersionRequest build() {
            if (this.request.moduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for GetLearningModuleVersionRequest.");
            }
            if (this.request.versionId == null) {
                throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetLearningModuleVersionRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        ASSESSMENTFORM("assessmentForm"),
        COVERART("coverArt");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

