/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DynamicGroupLanguageSkillCondition;
import com.mypurecloud.sdk.v2.model.DynamicGroupRoutingSkillCondition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DynamicGroupSkillCondition
implements Serializable {
    private List<DynamicGroupRoutingSkillCondition> routingSkillConditions = new ArrayList<DynamicGroupRoutingSkillCondition>();
    private List<DynamicGroupLanguageSkillCondition> languageSkillConditions = new ArrayList<DynamicGroupLanguageSkillCondition>();
    private OperationEnum operation = null;

    public DynamicGroupSkillCondition routingSkillConditions(List<DynamicGroupRoutingSkillCondition> routingSkillConditions) {
        this.routingSkillConditions = routingSkillConditions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Routing skill conditions that will be used for building the query")
    @JsonProperty(value="routingSkillConditions")
    public List<DynamicGroupRoutingSkillCondition> getRoutingSkillConditions() {
        return this.routingSkillConditions;
    }

    public void setRoutingSkillConditions(List<DynamicGroupRoutingSkillCondition> routingSkillConditions) {
        this.routingSkillConditions = routingSkillConditions;
    }

    public DynamicGroupSkillCondition languageSkillConditions(List<DynamicGroupLanguageSkillCondition> languageSkillConditions) {
        this.languageSkillConditions = languageSkillConditions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Routing skill conditions that will be used for building the query")
    @JsonProperty(value="languageSkillConditions")
    public List<DynamicGroupLanguageSkillCondition> getLanguageSkillConditions() {
        return this.languageSkillConditions;
    }

    public void setLanguageSkillConditions(List<DynamicGroupLanguageSkillCondition> languageSkillConditions) {
        this.languageSkillConditions = languageSkillConditions;
    }

    public DynamicGroupSkillCondition operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Operator that will be applied to the conditions")
    @JsonProperty(value="operation")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicGroupSkillCondition dynamicGroupSkillCondition = (DynamicGroupSkillCondition)o;
        return Objects.equals(this.routingSkillConditions, dynamicGroupSkillCondition.routingSkillConditions) && Objects.equals(this.languageSkillConditions, dynamicGroupSkillCondition.languageSkillConditions) && Objects.equals((Object)this.operation, (Object)dynamicGroupSkillCondition.operation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.routingSkillConditions, this.languageSkillConditions, this.operation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DynamicGroupSkillCondition {\n");
        sb.append("    routingSkillConditions: ").append(this.toIndentedString(this.routingSkillConditions)).append("\n");
        sb.append("    languageSkillConditions: ").append(this.toIndentedString(this.languageSkillConditions)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperationEnumDeserializer.class)
    public static enum OperationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AND("And"),
        NOT("Not"),
        OR("Or");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperationEnum value : OperationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperationEnumDeserializer
    extends StdDeserializer<OperationEnum> {
        public OperationEnumDeserializer() {
            super(OperationEnumDeserializer.class);
        }

        public OperationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperationEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

